<?php
/**

 *

 */
class Users_model extends CI_Model {

		var $table = 'users';
	var $column_order = array(null, 'companyname','user_type'); //,'full_name','phone'set column field database for datatable orderable
	var $column_search = array('companyname','user_type'); //,'full_name','phone'set column field database for datatable searchable 
	var $order = array('id' => 'DESC'); // default order 

	
	function __construct() {
		parent::__construct();
		

	}

private function _get_datatables_query($array_where=false)
	{
		
		$this->db->from($this->table);
		if($array_where != false)
			$this -> db -> where($array_where);

		$i = 0;
	
		foreach ($this->column_search as $item) // loop column 
		{
			if($_POST['search']['value']) // if datatable send POST for search
			{
				
				
				if($i===0) // first loop
				{
					$this->db->group_start(); // open bracket. query Where with OR clause better with bracket. because maybe can combine with other WHERE with AND.
					$this->db->like($item, $_POST['search']['value']);
				}
				else
				{
					$this->db->or_like($item, $_POST['search']['value']);
				}

				if(count($this->column_search) - 1 == $i) //last loop
					$this->db->group_end(); //close bracket
			}
			$i++;
		}
		
		if(isset($_POST['order'])) // here order processing
		{
			$this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
		} 
		else if(isset($this->order))
		{
			$order = $this->order;
			$this->db->order_by(key($order), $order[key($order)]);
		}
	}

function get_action($id,$activated)
{
	 $result='<div class="btn-group">
                  <button type="button" class="btn btn-info">Action</button>
                  <button type="button" class="btn btn-info dropdown-toggle" data-toggle="dropdown">
                    <span class="caret"></span>
                    <span class="sr-only">Toggle Dropdown</span>
                  </button>
                  <ul class="dropdown-menu" role="menu">';
                  if($activated == 1){
                    $result.='<li><a href="'.base_url().'admin/users/lock?id='.$id.'">InActive</a></li>'; }
                  	else {
                     $result.='<li><a href="'.base_url().'admin/users/activate?id='.$id.'">Active</a></li>';
                  	}
                     $result.='<li><a href="'.base_url().'admin/users/view?id='.$id.'" data-remote="false" data-toggle="modal" data-target="#modal-default">view</a></li><li><a href="'.base_url().'admin/users/edit_get?id='.$id.'">Edit</a></li>
                    <li><a href="'.base_url().'admin/users/delete?id='.$id.'" onclick="return confirm(\'Are you sure want to delete the record\')">Delete</a></li>                    
                  </ul>
                </div>';
                return $result;
}
	function get_datatables()
	{
		$where=array('user_type !='=>"ADM");
		$this->_get_datatables_query($where);
		if($_POST['length'] != -1)
		$this->db->limit($_POST['length'], $_POST['start']);
		$query = $this->db->get();
		
		return $query->result();
	}

	function count_filtered()
	{
		$where=array('user_type !='=>"ADM");
		$this->_get_datatables_query($where);
		$query = $this->db->get();
		return $query->num_rows();
	}

	public function count_all()
	{
		$where=array('user_type !='=>"ADM");
		$this->_get_datatables_query($where);
		$query = $this->db->get();
		return $query->num_rows();
	}
	function get($select = "*", $array_where = false, $array_like = false, $first = false, $offset = false, $order_by = false, $or_where = false) {
		$data = array();
		if( $order_by != false){
			$order = key($order_by);
			if ($order != null) {
				$sort = $order_by[$order];
				$this -> db -> order_by($order, $sort);
			}
		}

		$this -> db -> select($select);
		$this -> db -> from('users');
		if($array_where != false)
			$this -> db -> where($array_where);
		if($or_where != false)
			$this -> db -> or_where($or_where);		
		if($array_like != false)
			$this -> db -> like($array_like);
		if($offset != false){
			$this -> db -> limit($offset, $first);
		}

		$query = $this -> db -> get();
		//echo $this -> db -> last_query();
		if ($query -> num_rows() > 0) {
			foreach ($query->result() as $rows) {
				$data[] = $rows;
			}
			$query -> free_result();
			return $data;
		} else {
			return null;
		}
	}



	function total($array_where, $array_like) {
		$this -> db -> select('count(*) as total');
		$this -> db -> where($array_where);
		$this -> db -> like($array_like);
		$this -> db -> from('users');
		$query = $this -> db -> get();
		$rows = $query -> result();
		$query -> free_result();
		//echo  $this -> db ->last_query();
		return $rows[0] -> total;
	}
	

	function get_by_id($id) {
		$select = '*';
		$array_where = array('id' => $id);
		$array_like = array();
		$order_by = array();
		return $this -> get($select, $array_where, $array_like, 0, 1, $order_by);
	}

	function get_by_exact_phone($username) {
		$select = '*';
		$array_like = array();
		$array_where= array('phone'=>$username);
		$order_by = array();
		return $this -> get($select, $array_where, $array_like,0, 1, $order_by);
	}

	function get_by_phone_and_diff_id($id,$username) {
		$select = '*';
		$array_like = array();
		$array_where= array('phone'=>$username,'id !='=>$id);
		$order_by = array();
		return $this -> get($select, $array_where, $array_like,0, 1, $order_by);
	}

	
    function get_by_phone_and_pwd($phone, $pwd) {
		$select = '*';
		$array_like = array();
		$array_where= array('pwd'=>$pwd,'phone'=>$phone,'activated'=>1);
		$order_by = array();
		return $this -> get($select, $array_where, $array_like,0, 1, $order_by);
	}
	
	function insert($data_array) {
		$data_array['created_at']=date('Y-m-d H:i:s');
		$this -> db -> insert('users', $data_array);
		//return $this->db->last_query();		
		return $this -> db -> insert_id();
	}

	public function remove($arr_where) {
		$this -> db -> where($arr_where);
		$this -> db -> delete('users');
		return $this->db->affected_rows();
	}

	public function remove_by_id($id) {
		$array_where = array('id' => $id);
		return $this -> remove($array_where);
	}

	function update($data_array, $array_where) {
		$this -> db -> where($array_where);
		$data_array['updated_at']=date('Y-m-d H:i:s');

		return $this -> db -> update('users', $data_array);
	}   
   

}
?>
