<?php
/**

 *

 */
class Receipt_model extends CI_Model {

		var $table = 'payment';
	var $column_order = array(null, 'payment.name','users.companyname','payment.amount','payment.billdate','voucher.vouchername'); //,'orderstatus'set column field database for datatable orderable
	var $column_search = array('payment.name','users.companyname','payment.amount','payment.billdate','voucher.vouchername'); //,'orderstatus'set column field database for datatable searchable 
	var $order = array('payment.id' => 'DESC'); // default order 

	
	function __construct() {
		parent::__construct();
		$this->load->model('users_model');
		$this->load->model('quality_model');
		$this->load->model('voucher_model');

	}

private function _get_datatables_query($array_where=false)
	{
		$select  = ' payment.*,users.companyname as companyname,voucher.name as vouchername';
		$this->db-> select($select);
		$this->db->from($this->table);
		if($array_where != false)
			$this -> db -> where($array_where);

		$i = 0;
	
		foreach ($this->column_search as $item) // loop column 
		{
			if($_POST['search']['value']) // if datatable send POST for search
			{
				
				
				if($i===0) // first loop
				{
					$this->db->group_start(); // open bracket. query Where with OR clause better with bracket. because maybe can combine with other WHERE with AND.
					$this->db->like($item, $_POST['search']['value']);
				}
				else
				{
					$this->db->or_like($item, $_POST['search']['value']);
				}

				if(count($this->column_search) - 1 == $i) //last loop
					$this->db->group_end(); //close bracket
			}
			$i++;
		}
		
		if(isset($_POST['order'])) // here order processing
		{
			$this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
		} 
		else if(isset($this->order))
		{
			$order = $this->order;
			$this->db->order_by(key($order), $order[key($order)]);
		}
	}

function get_action($id,$activated)
{
	
	 $result='<div class="btn-group">
                  <button type="button" class="btn btn-info">Action</button>
                  <button type="button" class="btn btn-info dropdown-toggle" data-toggle="dropdown">
                    <span class="caret"></span>
                    <span class="sr-only">Toggle Dropdown</span>
                  </button>
                  <ul class="dropdown-menu" role="menu">';
                
                     $result.='<li><a href="'.base_url().'admin/receipt/view?id='.$id.'" >view</a></li>
                     <li><a href="'.base_url().'admin/receipt/edit_get?id='.$id.'">Edit</a></li>   
                    <li><a href="'.base_url().'admin/receipt/delete?id='.$id.'" onclick="return confirm(\'Are you sure want to delete the record\')">Delete</a></li>                    
                  </ul>
                </div>';
                return $result;
}
	function get_datatables()
	{		
		$this->_get_datatables_query();
		if($_POST['length'] != -1)
		$this->db->limit($_POST['length'], $_POST['start']);
		$this->db->join('users','payment.userid = users.id','inner');
		$this->db->join('voucher','payment.voucher_id = voucher.id','inner');
		$array_where["voucher.type"]="receipt";
		$array_where["voucher.id<>"]=1;
		$this -> db -> where($array_where);
		$query = $this->db->get();
		//echo $this -> db -> last_query();
		return $query->result();
	}

	function count_filtered()
	{
		
		$this->_get_datatables_query();
		$this->db->join('users','payment.userid = users.id','inner');
		$this->db->join('voucher','payment.voucher_id = voucher.id','inner');
		$array_where["voucher.type"]="receipt";
		$array_where["voucher.id<>"]=1;
		$this -> db -> where($array_where);
		$query = $this->db->get();
		return $query->num_rows();
	}

	public function count_all()
	{
		$this->db->from($this->table);
		$this->db->join('users','payment.userid = users.id','inner');
		$this->db->join('voucher','payment.voucher_id = voucher.id','inner');
		$array_where["voucher.type"]="receipt";
		$array_where["voucher.id<>"]=1;
		$this -> db -> where($array_where);
		return $this->db->count_all_results();
	}
	function get($select = "*", $array_where = false, $array_like = false, $first = false, $offset = false, $order_by = false) {
		$data = array();
		if( $order_by != false){
			$order = key($order_by);
			if ($order != null) {
				$sort = $order_by[$order];
				$this -> db -> order_by($order, $sort);
			}
		}

		$this -> db -> select($select);
		$this -> db -> from('payment');
		if($array_where != false)
			$this -> db -> where($array_where);
		if($array_like != false)
			$this -> db -> like($array_like);
		if($offset != false){
			$this -> db -> limit($offset, $first);
		}

		$query = $this -> db -> get();
		$this -> db -> last_query();
		if ($query -> num_rows() > 0) {
			foreach ($query->result() as $rows) {
				$user_arr = $this->users_model->get_by_id($rows->userid);				
				if(is_array($user_arr))
				{
					 $rows->userid =$user_arr[0]->companyname;
				}
				else
				{
					 $rows->userid = "";
				}

				$vouc_arr = $this->voucher_model->get_by_id($rows->voucher_id);				
				if(is_array($vouc_arr))
				{
					 $rows->voucher_id =$vouc_arr[0]->name;
					 $rows->voucherid =$vouc_arr[0]->id;
				}
				else
				{
					 $rows->voucher_id = "";
					 $rows->voucherid =$vouc_arr[0]->id;
				}
				
				$rows->billdate =revert_time_format($rows->billdate);
				
				$data[] = $rows;
				
			}
			$query -> free_result();
			return $data;
		} else {
			return null;
		}
	}
function get_by_id($id) {
		$select = '*';
		$array_where = array('id' => $id);
		$array_like = array();
		$order_by = array();
		return $this -> get($select, $array_where, $array_like, 0, 1, $order_by);
	}	

function get_Order_details($select = "*", $array_where = false, $array_like = false, $first = false, $offset = false, $order_by = false) {
		$data = array();
		if( $order_by != false){
			$order = key($order_by);
			if ($order != null) {
				$sort = $order_by[$order];
				$this -> db -> order_by($order, $sort);
			}
		}

		$this -> db -> select($select);
		$this -> db -> from('orderdetails');
		if($array_where != false)
			$this -> db -> where($array_where);
		if($array_like != false)
			$this -> db -> like($array_like);
		if($offset != false){
			$this -> db -> limit($offset, $first);
		}

		$query = $this -> db -> get();
		//echo $this -> db -> last_query();
		if ($query -> num_rows() > 0) {
			foreach ($query->result() as $rows) {
				$user_arr = $this->quality_model->get_by_id($rows->quality);
				$rows->qualityid=$rows->quality;				
				if(is_array($user_arr))
				{
					$rows->quality =$user_arr[0]->name;
				}
				else
				{
					$rows->quality = "";
				}
				$rows->ordertype =ORDERTYPEARRAY[$rows->ordertype];				
				$data[] = $rows;
			}
			$query -> free_result();
			return $data;
		} else {
			return null;
		}
	}

		function insert($data_array) {
		$data_array['created_at']=date('Y-m-d H:i:s');
		$this -> db -> insert('payment', $data_array);
		//return $this->db->last_query();		
		return $this -> db -> insert_id();
	}

	public function remove($arr_where) {
		$this -> db -> where($arr_where);
		$this -> db -> delete('payment');
		return $this->db->affected_rows();
	}

	
	public function remove_by_id($id) {
		$array_where = array('id' => $id);
		return $this -> remove($array_where);
	}

	function update($data_array, $array_where) {
		$this -> db -> where($array_where);
		$data_array['updated_at']=date('Y-m-d H:i:s');
		return $this -> db -> update('payment', $data_array);
	}   
   
	 
}
?>
