<?php
/**

 *

 */
class Process_model extends CI_Model {

		

	
	function __construct() {
		parent::__construct();
		$this->load->model('users_model');
		$this->load->model('quality_model');
$this->load->model('orders_model');
	}

	
	function get($select = "*", $array_where = false, $array_like = false, $first = false, $offset = false, $order_by = false) {
		$data = array();
		if( $order_by != false){
			$order = key($order_by);
			if ($order != null) {
				$sort = $order_by[$order];
				$this -> db -> order_by($order, $sort);
			}
		}

		$this -> db -> select($select);
		$this -> db -> from('orderprocessinwards');
		if($array_where != false)
			$this -> db -> where($array_where);
		if($array_like != false)
			$this -> db -> like($array_like);
		if($offset != false){
			$this -> db -> limit($offset, $first);
		}

		$query = $this -> db -> get();
		//echo $this -> db -> last_query();
		if ($query -> num_rows() > 0) {
			foreach ($query->result() as $rows) {
				$user_arr = $this->users_model->get_by_id($rows->userid);				
				if(is_array($user_arr))
				{
					$rows->username =$user_arr[0]->companyname;
				}
				else
				{
					$rows->username = "";
				}
				if($rows->status =="0")$rows->statusname="Inwards";
				if($rows->status =="1")$rows->statusname="Outwards";
				$user_arr = $this->orders_model->get_Order_details("*",array("id"=>$rows->orderdetailsid));
				 $rows->qualityid=$user_arr[0]->quality;
				 $rows->qualityname=$user_arr[0]->description;
				$rows->dcdate =revert_time_format($rows->dcdate);
				
				$data[] = $rows;
				
			}
			$query -> free_result();
			return $data;
		} else {
			return null;
		}
	}

function get_outwards($select = "*", $array_where = false, $array_like = false, $first = false, $offset = false, $order_by = false) {
		$data = array();
		if( $order_by != false){
			$order = key($order_by);
			if ($order != null) {
				$sort = $order_by[$order];
				$this -> db -> order_by($order, $sort);
			}
		}

		$this -> db -> select($select);
		$this -> db -> from('orderprocessoutwards');
		if($array_where != false)
			$this -> db -> where($array_where);
		if($array_like != false)
			$this -> db -> like($array_like);
		if($offset != false){
			$this -> db -> limit($offset, $first);
		}

		$query = $this -> db -> get();
		//echo $this -> db -> last_query();
		if ($query -> num_rows() > 0) {
			foreach ($query->result() as $rows) {
				$user_arr = $this->users_model->get_by_id($rows->userid);				
				if(is_array($user_arr))
				{
					$rows->username =$user_arr[0]->companyname;
				}
				else
				{
					$rows->username = "";
				}
				if($rows->status =="0")$rows->statusname="Inwards";
				if($rows->status =="1")$rows->statusname="Outwards";
				$user_arr = $this->orders_model->get_Order_details("*",array("id"=>$rows->orderdetailsid));
				 $rows->qualityid=$user_arr[0]->quality;
				 $rows->qualityname=$user_arr[0]->description;
				$rows->outdcdate =revert_time_format($rows->outdcdate);
				
				$data[] = $rows;
				
			}
			$query -> free_result();
			return $data;
		} else {
			return null;
		}
	}

	function get_Order_uploadpo($select = "*", $array_where = false, $array_like = false, $first = false, $offset = false, $order_by = false) {
		$data = array();
		if( $order_by != false){
			$order = key($order_by);
			if ($order != null) {
				$sort = $order_by[$order];
				$this -> db -> order_by($order, $sort);
			}
		}

		$this -> db -> select($select);
		$this -> db -> from('orderuploadpo');
		if($array_where != false)
			$this -> db -> where($array_where);
		if($array_like != false)
			$this -> db -> like($array_like);
		if($offset != false){
			$this -> db -> limit($offset, $first);
		}

		$query = $this -> db -> get();
		//echo $this -> db -> last_query();
		if ($query -> num_rows() > 0) {
			foreach ($query->result() as $rows) {
							
				$data[] = $rows;
			}
			$query -> free_result();
			return $data;
		} else {
			return null;
		}
	}

	function total($array_where, $array_like) {
		$this -> db -> select('count(*) as total');
		$this -> db -> where($array_where);
		$this -> db -> like($array_like);
		$this -> db -> from('orders');
		$query = $this -> db -> get();
		$rows = $query -> result();
		$query -> free_result();
		//echo  $this -> db ->last_query();
		return $rows[0] -> total;
	}
	

	function get_by_id($id) {
		$select = '*';
		$array_where = array('id' => $id);
		$array_like = array();
		$order_by = array();
		return $this -> get($select, $array_where, $array_like, 0, 1, $order_by);
	}	

	function get_by_exact_name($name) {
		$select = '*';
		$array_like = array();
		$array_where= array('name'=>$name);
		$order_by = array();
		return $this -> get($select, $array_where, $array_like,0, 1, $order_by);
	}

	function get_by_name_and_diff_id($id,$name) {
		$select = '*';
		$array_like = array();
		$array_where= array('name'=>$name,'id !='=>$id);
		$order_by = array();
		return $this -> get($select, $array_where, $array_like,0, 1, $order_by);
	}	
    
	
	function insert($data_array) {
		$data_array['created_at']=date('Y-m-d H:i:s');
		$this -> db -> insert('orderprocessinwards', $data_array);
		//return $this->db->last_query();		
		return $this -> db -> insert_id();
	}

	function insert_out($data_array) {
		$data_array['created_at']=date('Y-m-d H:i:s');
		$this -> db -> insert('orderprocessoutwards', $data_array);
		//return $this->db->last_query();		
		return $this -> db -> insert_id();
	}

	function insert_orderuploadpo($data_array) {
		$data_array['created_at']=date('Y-m-d H:i:s');
		$this -> db -> insert('orderuploadpo', $data_array);
		//return $this->db->last_query();		
		return $this -> db -> insert_id();
	}

	public function remove($arr_where) {
		$this -> db -> where($arr_where);
		$this -> db -> delete('orderprocessinwards');
		return $this->db->affected_rows();
	}

	public function remove_orderuploadpo($arr_where) {
		$this -> db -> where($arr_where);
		$this -> db -> delete('orderuploadpo');
		return $this->db->affected_rows();
	}

	
	public function remove_by_id($id) {
		$array_where = array('id' => $id);
		return $this -> remove($array_where);
	}

	function update($data_array, $array_where) {
		$this -> db -> where($array_where);
		$data_array['updated_at']=date('Y-m-d H:i:s');
		return $this -> db -> update('orderprocessinwards', $data_array);
	} 
	function update_out($data_array, $array_where) {
		$this -> db -> where($array_where);
		$data_array['updated_at']=date('Y-m-d H:i:s');
		return $this -> db -> update('orderprocessoutwards', $data_array);
	}   
   

}
?>
