<?php
/**

 *

 */
class Orders_model extends CI_Model {

		var $table = 'orders';
	var $column_order = array(null, 'orders.name','users.companyname','orders.jobtype'); //,'orderstatus'set column field database for datatable orderable
	var $column_search = array('orders.name','users.companyname','orders.jobtype'); //,'orderstatus'set column field database for datatable searchable 
	var $order = array('orders.id' => 'DESC'); // default order 

	
	function __construct() {
		parent::__construct();
		$this->load->model('users_model');
		$this->load->model('quality_model');

	}

private function _get_datatables_query($array_where=false)
	{
		$select  = ' orders.*,users.companyname as companyname';
		$this->db-> select($select);
		$this->db->from($this->table);
		if($array_where != false)
			$this -> db -> where($array_where);

		$i = 0;
	
		foreach ($this->column_search as $item) // loop column 
		{
			if($_POST['search']['value']) // if datatable send POST for search
			{
				
				
				if($i===0) // first loop
				{
					$this->db->group_start(); // open bracket. query Where with OR clause better with bracket. because maybe can combine with other WHERE with AND.
					$this->db->like($item, $_POST['search']['value']);
				}
				else
				{
					$this->db->or_like($item, $_POST['search']['value']);
				}

				if(count($this->column_search) - 1 == $i) //last loop
					$this->db->group_end(); //close bracket
			}
			$i++;
		}
		
		if(isset($_POST['order'])) // here order processing
		{
			$this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
		} 
		else if(isset($this->order))
		{
			$order = $this->order;
			$this->db->order_by(key($order), $order[key($order)]);
		}
	}

function get_action($id,$activated)
{
	 $result='<div class="btn-group">
                  <button type="button" class="btn btn-info">Action</button>
                  <button type="button" class="btn btn-info dropdown-toggle" data-toggle="dropdown">
                    <span class="caret"></span>
                    <span class="sr-only">Toggle Dropdown</span>
                  </button>
                  <ul class="dropdown-menu" role="menu">';
                 /* if($activated == 1){
                    $result.='<li><a href="'.base_url().'admin/orders/lock?id='.$id.'">InActive</a></li>'; }
                  	else {
                     $result.='<li><a href="'.base_url().'admin/orders/activate?id='.$id.'">Active</a></li>';
                  	}*//*<li><a href="'.base_url().'admin/bill/create?orderid='.$id.'">Bill</a></li>*/
                     $result.='<li><a href="'.base_url().'admin/orders/view?id='.$id.'" >view</a></li>
                     <li><a href="'.base_url().'admin/orders/edit_get?id='.$id.'">Edit</a></li>
                     
                     <li><a href="'.base_url().'admin/grey/create?id='.$id.'">Grey</a></li>
                     <li><a href="'.base_url().'admin/process/create?id='.$id.'">Processing</a></li>
                    <li><a href="'.base_url().'admin/orders/delete?id='.$id.'" onclick="return confirm(\'Are you sure want to delete the record\')">Delete</a></li>                    
                  </ul>
                </div>';
                return $result;
}
	function get_datatables()
	{		
		$this->_get_datatables_query();
		if($_POST['length'] != -1)
		$this->db->limit($_POST['length'], $_POST['start']);
	$this->db->join('users','orders.userid = users.id','inner');
		$query = $this->db->get();
		//echo $this -> db -> last_query();
		return $query->result();
	}

	function count_filtered()
	{
		
		$this->_get_datatables_query();
		$this->db->join('users','orders.userid = users.id','inner');
		$query = $this->db->get();
		return $query->num_rows();
	}

	public function count_all()
	{
		$this->db->from($this->table);
		$this->db->join('users','orders.userid = users.id','inner');
		return $this->db->count_all_results();
	}
	function get($select = "*", $array_where = false, $array_like = false, $first = false, $offset = false, $order_by = false) {
		$data = array();
		if( $order_by != false){
			$order = key($order_by);
			if ($order != null) {
				$sort = $order_by[$order];
				$this -> db -> order_by($order, $sort);
			}
		}

		$this -> db -> select($select);
		$this -> db -> from('orders');
		if($array_where != false)
			$this -> db -> where($array_where);
		if($array_like != false)
			$this -> db -> like($array_like);
		if($offset != false){
			$this -> db -> limit($offset, $first);
		}

		$query = $this -> db -> get();
		//echo $this -> db -> last_query();
		if ($query -> num_rows() > 0) {
			foreach ($query->result() as $rows) {
				$user_arr = $this->users_model->get_by_id($rows->userid);				
				if(is_array($user_arr))
				{
					$rows->userid =$user_arr[0]->companyname;
					$rows->user_address =$user_arr[0]->address;
					$rows->user_gst =$user_arr[0]->gst;
					$rows->user_id =$user_arr[0]->id;
				}
				else
				{
					$rows->userid = "";
					$rows->user_address = "";
					$rows->user_gst = "";
					$rows->user_id =$user_arr[0]->id;
				}
				$rows->confirmdate =revert_time_format($rows->confirmdate);
				$rows->jobtype =JOBTYPEARRAY[$rows->jobtype];
				$rows->orderconfirmfrom =ORDERCONFRIMARRAY[$rows->orderconfirmfrom];
				$data[] = $rows;
				
			}
			$query -> free_result();
			return $data;
		} else {
			return null;
		}
	}

function get_image($select = "*", $array_where = false, $array_like = false, $first = false, $offset = false, $order_by = false) {
		$data = array();
		if( $order_by != false){
			$order = key($order_by);
			if ($order != null) {
				$sort = $order_by[$order];
				$this -> db -> order_by($order, $sort);
			}
		}
		$this -> db -> order_by('id', 'desc');
		$this -> db -> select($select,false);
		$this -> db -> from('orderuploadpo');
		if($array_where != false)
			$this -> db -> where($array_where);
		if($array_like != false)
			$this -> db -> like($array_like);
		if($offset != false){
			$this -> db -> limit($offset, $first);
		}

		$query = $this -> db -> get();
		//echo  $this -> db -> last_query();		
		if ($query -> num_rows() > 0) {
			foreach ($query->result() as $rows) {

				$data[] = $rows;
			}
			$query -> free_result();
			return $data;
		} else {
			return null;
		}
	}
function get_Order_details($select = "*", $array_where = false, $array_like = false, $first = false, $offset = false, $order_by = false) {
		$data = array();
		if( $order_by != false){
			$order = key($order_by);
			if ($order != null) {
				$sort = $order_by[$order];
				$this -> db -> order_by($order, $sort);
			}
		}

		$this -> db -> select($select);
		$this -> db -> from('orderdetails');
		if($array_where != false)
			$this -> db -> where($array_where);
		if($array_like != false)
			$this -> db -> like($array_like);
		if($offset != false){
			$this -> db -> limit($offset, $first);
		}

		$query = $this -> db -> get();
		//echo $this -> db -> last_query();
		if ($query -> num_rows() > 0) {
			foreach ($query->result() as $rows) {
				$user_arr = $this->quality_model->get_by_id($rows->quality);
				$rows->qualityid=$rows->quality;				
				if(is_array($user_arr))
				{
					$rows->quality =$user_arr[0]->name;
				}
				else
				{
					$rows->quality = "";
				}
				$rows->ordertype =ORDERTYPEARRAY[$rows->ordertype];				
				$data[] = $rows;
			}
			$query -> free_result();
			return $data;
		} else {
			return null;
		}
	}

	function get_Order_uploadpo($select = "*", $array_where = false, $array_like = false, $first = false, $offset = false, $order_by = false) {
		$data = array();
		if( $order_by != false){
			$order = key($order_by);
			if ($order != null) {
				$sort = $order_by[$order];
				$this -> db -> order_by($order, $sort);
			}
		}

		$this -> db -> select($select);
		$this -> db -> from('orderuploadpo');
		if($array_where != false)
			$this -> db -> where($array_where);
		if($array_like != false)
			$this -> db -> like($array_like);
		if($offset != false){
			$this -> db -> limit($offset, $first);
		}

		$query = $this -> db -> get();
		//echo $this -> db -> last_query();
		if ($query -> num_rows() > 0) {
			foreach ($query->result() as $rows) {
							
				$data[] = $rows;
			}
			$query -> free_result();
			return $data;
		} else {
			return null;
		}
	}

	function total($array_where, $array_like) {
		$this -> db -> select('count(*) as total');
		$this -> db -> where($array_where);
		$this -> db -> like($array_like);
		$this -> db -> from('orders');
		$query = $this -> db -> get();
		$rows = $query -> result();
		$query -> free_result();
		//echo  $this -> db ->last_query();
		return $rows[0] -> total;
	}
	

	function get_by_id($id) {
		$select = '*';
		$array_where = array('id' => $id);
		$array_like = array();
		$order_by = array();
		return $this -> get($select, $array_where, $array_like, 0, 1, $order_by);
	}	

	function get_by_exact_name($name) {
		$select = '*';
		$array_like = array();
		$array_where= array('name'=>$name);
		$order_by = array();
		return $this -> get($select, $array_where, $array_like,0, 1, $order_by);
	}

	function get_by_name_and_diff_id($id,$name) {
		$select = '*';
		$array_like = array();
		$array_where= array('name'=>$name,'id !='=>$id);
		$order_by = array();
		return $this -> get($select, $array_where, $array_like,0, 1, $order_by);
	}	
    
	
	function insert($data_array) {
		$data_array['created_at']=date('Y-m-d H:i:s');
		$this -> db -> insert('orders', $data_array);
		//return $this->db->last_query();		
		return $this -> db -> insert_id();
	}

	function insert_orderdetails($data_array) {
		$data_array['created_at']=date('Y-m-d H:i:s');
		$this -> db -> insert('orderdetails', $data_array);
		//return $this->db->last_query();		
		return $this -> db -> insert_id();
	}

	function insert_orderuploadpo($data_array) {
		$data_array['created_at']=date('Y-m-d H:i:s');
		$this -> db -> insert('orderuploadpo', $data_array);
		//return $this->db->last_query();		
		return $this -> db -> insert_id();
	}

	public function remove($arr_where) {
		$this -> db -> where($arr_where);
		$this -> db -> delete('orders');
		return $this->db->affected_rows();
	}

	public function remove_orderuploadpo($arr_where) {
		$this -> db -> where($arr_where);
		$this -> db -> delete('orderuploadpo');
		return $this->db->affected_rows();
	}

	public function remove_orderdetails($arr_where) {
		$this -> db -> where($arr_where);
		$this -> db -> delete('orderdetails');
		return $this->db->affected_rows();
	}

	public function remove_by_id($id) {
		$array_where = array('id' => $id);
		return $this -> remove($array_where);
	}

	function update($data_array, $array_where) {
		$this -> db -> where($array_where);
		$data_array['updated_at']=date('Y-m-d H:i:s');
		return $this -> db -> update('orders', $data_array);
	}   
   
	function update_orderdetails($data_array, $array_where) {
		$this -> db -> where($array_where);
		$data_array['updated_at']=date('Y-m-d H:i:s');
		return $this -> db -> update('orderdetails', $data_array);
	}   
}
?>
