<?php
/**

 *

 */
class Bill_model extends CI_Model {

	var $table = 'bill';
	var $column_order = array(null, 'bill.billno','bill.billdate','orders.name','bill.grandtotal'); //,'orderstatus'set column field database for datatable orderable
	var $column_search = array('bill.billno','bill.billdate','orders.name','bill.grandtotal'); //,'orderstatus'set column field database for datatable searchable 
	var $order = array('bill.id' => 'DESC'); // default order	

	
	function __construct() {
		parent::__construct();
		$this->load->model('users_model');
		$this->load->model('orders_model');
		$this->load->model('quality_model');

	}
private function _get_datatables_query($array_where=false)
	{
		$select  = ' bill.*,users.companyname as companyname,orders.name as name';
		$this->db-> select($select);
		$this->db->from($this->table);
		if($array_where != false)
			$this -> db -> where($array_where);

		$i = 0;
	
		foreach ($this->column_search as $item) // loop column 
		{
			if($_POST['search']['value']) // if datatable send POST for search
			{
				
				
				if($i===0) // first loop
				{
					$this->db->group_start(); // open bracket. query Where with OR clause better with bracket. because maybe can combine with other WHERE with AND.
					$this->db->like($item, $_POST['search']['value']);
				}
				else
				{
					$this->db->or_like($item, $_POST['search']['value']);
				}

				if(count($this->column_search) - 1 == $i) //last loop
					$this->db->group_end(); //close bracket
			}
			$i++;
		}
		
		if(isset($_POST['order'])) // here order processing
		{
			$this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
			
		} 
		else if(isset($this->order))
		{
			$order = $this->order;
			//$this->db->order_by(key($order), $order[key($order)]);
			$this->db->order_by("billno", "desc");
		}
		
	}

function get_action($id,$activated,$orderid)
{
	 $result='<div class="btn-group">
                  <button type="button" class="btn btn-info">Action</button>
                  <button type="button" class="btn btn-info dropdown-toggle" data-toggle="dropdown">
                    <span class="caret"></span>
                    <span class="sr-only">Toggle Dropdown</span>
                  </button>
                  <ul class="dropdown-menu" role="menu">';
                 
                     $result.='
                     <li><a href="'.base_url().'admin/bill/invoice?orderid='.$orderid.'&billid='.$id.'"  target="_blank">Print</a></li>
                     <li><a href="'.base_url().'admin/bill/view?orderid='.$orderid.'&billid='.$id.'" >view</a></li>
                     <li><a href="'.base_url().'admin/bill/edit_get?orderid='.$orderid.'&billid='.$id.'">Edit</a></li>
                    
                    <li><a href="'.base_url().'admin/bill/delete?id='.$id.'" onclick="return confirm(\'Are you sure want to delete the record\')">Delete</a></li>                    
                  </ul>
                </div>';/*'.base_url().'admin/bill/edit_get?id='.$id.'*/
                return $result;
}
	function get_datatables()
	{		
		$this->_get_datatables_query();
		if($_POST['length'] != -1)
		$this->db->limit($_POST['length'], $_POST['start']);
		$this->db->join('orders','bill.orderid = orders.id','inner');
		$this->db->join('users','orders.userid = users.id','inner');
		
		$query = $this->db->get();
		//echo $this -> db -> last_query();
		return $query->result();
	}

	function count_filtered()
	{
		
		$this->_get_datatables_query();
		$this->db->join('orders','bill.orderid = orders.id','inner');
		$this->db->join('users','orders.userid = users.id','inner');
		$query = $this->db->get();
		return $query->num_rows();
	}

	public function count_all()
	{
		$this->db->from($this->table);
		$this->db->join('orders','bill.orderid = orders.id','inner');
		$this->db->join('users','orders.userid = users.id','inner');
		return $this->db->count_all_results();
	}

	public function count_all_amount()
	{
		$this->db->select('SUM(grandtotal) AS amount', FALSE);
		$this->db->from($this->table);
		$this->db->join('orders','bill.orderid = orders.id','inner');
		$this->db->join('users','orders.userid = users.id','inner');
		$que= $this->db->get();
		$query=$que->result_array();
		//echo $this -> db -> last_query();				
		return $query;
	}

	function getIndianCurrency(float $number)
{
    $decimal = round($number - ($no = floor($number)), 2) * 100;
    $hundred = null;
    $digits_length = strlen($no);
    $i = 0;
    $str = array();
    $words = array(0 => '', 1 => 'one', 2 => 'two',
        3 => 'three', 4 => 'four', 5 => 'five', 6 => 'six',
        7 => 'seven', 8 => 'eight', 9 => 'nine',
        10 => 'ten', 11 => 'eleven', 12 => 'twelve',
        13 => 'thirteen', 14 => 'fourteen', 15 => 'fifteen',
        16 => 'sixteen', 17 => 'seventeen', 18 => 'eighteen',
        19 => 'nineteen', 20 => 'twenty', 30 => 'thirty',
        40 => 'forty', 50 => 'fifty', 60 => 'sixty',
        70 => 'seventy', 80 => 'eighty', 90 => 'ninety');
    $digits = array('', 'hundred','thousand','lakh', 'crore');
    while( $i < $digits_length ) {
        $divider = ($i == 2) ? 10 : 100;
        $number = floor($no % $divider);
        $no = floor($no / $divider);
        $i += $divider == 10 ? 1 : 2;
        if ($number) {
            $plural = (($counter = count($str)) && $number > 9) ? 's' : null;
            $hundred = ($counter == 1 && $str[0]) ? ' and ' : null;
            $str [] = ($number < 21) ? $words[$number].' '. $digits[$counter]. $plural.' '.$hundred:$words[floor($number / 10) * 10].' '.$words[$number % 10]. ' '.$digits[$counter].$plural.' '.$hundred;
        } else $str[] = null;
    }
    $Rupees = implode('', array_reverse($str));
    $paise = ($decimal) ? "." . ($words[$decimal / 10] . " " . $words[$decimal % 10]) . ' Paise' : '';
    return ($Rupees ? $Rupees . 'Only' : '');// . $paise ;
}
	
	function get($select = "*", $array_where = false, $array_like = false, $first = false, $offset = false, $order_by = false) {
		$data = array();
		if( $order_by != false){
			$order = key($order_by);
			if ($order != null) {
				$sort = $order_by[$order];
				$this -> db -> order_by($order, $sort);
			}
		}
		
		$this -> db -> select($select);
		$this -> db -> from('bill');
		if($array_where != false)
			$this -> db -> where($array_where);
		if($array_like != false)
			$this -> db -> like($array_like);
		if($offset != false){
			$this -> db -> limit($offset, $first);
		}

		$query = $this -> db -> get();
		//echo $this -> db -> last_query();
		if ($query -> num_rows() > 0) {
			foreach ($query->result() as $rows) {
				$order_arr = $this->orders_model->get_by_id($rows->orderid);
				$rows->username =$order_arr[0]->userid;
				$rows->bill_date=$rows->billdate;
				$rows->billdate =revert_time_format($rows->billdate);
				$rows->grand_total = $this ->getIndianCurrency($rows->grandtotal);
				
				$data[] = $rows;
				
			}
			$query -> free_result();
			return $data;
		} else {
			return null;
		}
	}



	function get_bill_details($select = "*", $array_where = false, $array_like = false, $first = false, $offset = false, $order_by = false) {
		$data = array();
		if( $order_by != false){
			$order = key($order_by);
			if ($order != null) {
				$sort = $order_by[$order];
				$this -> db -> order_by($order, $sort);
			}
		}

		$this -> db -> select($select);
		$this -> db -> from('billdetails');
		if($array_where != false)
			$this -> db -> where($array_where);
		if($array_like != false)
			$this -> db -> like($array_like);
		if($offset != false){
			$this -> db -> limit($offset, $first);
		}

		$query = $this -> db -> get();
		//echo $this -> db -> last_query();
		if ($query -> num_rows() > 0) {
			foreach ($query->result() as $rows) {
				$user_arr = $this->orders_model->get_Order_details("*",array("id"=>$rows->orderdetailsid));
				 $rows->qualityid=$user_arr[0]->quality;	
				$rows->billdescription=$user_arr[0]->description;
						
				
							
				$data[] = $rows;
			}
			$query -> free_result();
			return $data;
		} else {
			return null;
		}
	}

	function total($array_where, $array_like) {
		$this -> db -> select('count(*) as total');
		$this -> db -> where($array_where);
		$this -> db -> like($array_like);
		$this -> db -> from('bill');
		$query = $this -> db -> get();
		$rows = $query -> result();
		$query -> free_result();
		//echo  $this -> db ->last_query();
		return $rows[0] -> total;
	}
	
	function get_last_bill_id() {
		$select = '*';
		$array_where = array();
		$array_like = array();
		$order_by = array("billno"=>"desc");
		return $this -> get($select, $array_where, $array_like, 0, 1, $order_by);
	}	

	function get_by_id($id) {
		$select = '*';
		$array_where = array('id' => $id);
		$array_like = array();
		$order_by = array();
		return $this -> get($select, $array_where, $array_like, 0, 1, $order_by);
	}	

	function get_by_exact_name($name) {
		$select = '*';
		$array_like = array();
		$array_where= array('name'=>$name);
		$order_by = array();
		return $this -> get($select, $array_where, $array_like,0, 1, $order_by);
	}

	function get_by_name_and_diff_id($id,$name) {
		$select = '*';
		$array_like = array();
		$array_where= array('name'=>$name,'id !='=>$id);
		$order_by = array();
		return $this -> get($select, $array_where, $array_like,0, 1, $order_by);
	}	
    
	
	function insert($data_array) {
		$data_array['created_at']=date('Y-m-d H:i:s');
		$this -> db -> insert('bill', $data_array);
		//return $this->db->last_query();		
		return $this -> db -> insert_id();
	}

	

	function insert_billdetails($data_array) {
		$data_array['created_at']=date('Y-m-d H:i:s');
		$this -> db -> insert('billdetails', $data_array);
		//return $this->db->last_query();		
		return $this -> db -> insert_id();
	}

	function update_billdetails($data_array, $array_where) {	
		$this -> db -> where($array_where);
		$data_array['updated_at']=date('Y-m-d H:i:s');
		return $this -> db -> update('billdetails', $data_array);
	}

	public function remove($arr_where) {
		$this -> db -> where($arr_where);
		$this -> db -> delete('bill');
		return $this->db->affected_rows();
	}

	public function remove_billdetails($arr_where) {
		$this -> db -> where($arr_where);
		$this -> db -> delete('billdetails');
		return $this->db->affected_rows();
	}

	
	public function remove_by_id($id) {
		$array_where = array('id' => $id);
		return $this -> remove($array_where);
	}

	function update($data_array, $array_where) {
		$this -> db -> where($array_where);
		$data_array['updated_at']=date('Y-m-d H:i:s');
		return $this -> db -> update('bill', $data_array);
	}   
   

}
?>
