<?php
class Quality extends MY_Controller{
	function __construct()
	{
		parent::__construct();
		if(!isset($_SESSION['user'])){
			redirect('admin/dashboard');
		}else{
			$user=$_SESSION['user'][0];
			if($user->user_type !="ADM" ){
				redirect('admin/denied');
			}
		}
		$this->load->model('quality_model');
		$this->load->model('users_model');
		$this->load->model('orders_model');
		$this->form_validation->set_error_delimiters('<span class="help-inline msg-error" generated="true">', '</span>');
		$this->load->helper('Ultils');
	}

	function index(){
		
		$this->render_backend_tp('backends/quality/index');
	}

	public function ajax_list()
	{
		$list = $this->quality_model->get_datatables();
		$data = array();
		$no = $_POST['start'];
		foreach ($list as $customers) {
			$no++;
			$row = array();
			$row[] = $no;
			$row[] = $customers->name;
			$row[] = $this->quality_model->get_action($customers->id);

			$data[] = $row;
		}

		$output = array(
						"draw" => $_POST['draw'],
						"recordsTotal" => $this->quality_model->count_all(),
						"recordsFiltered" => $this->quality_model->count_filtered(),
						"data" => $data,
				);
		//output to json format
		echo json_encode($output);
	}


	public function create(){
		$error=null;
		if(isset($_POST['qualityname'])){		
			
			$this->form_validation->set_rules('qualityname','qualityname', 'trim|required|min_length[3]|callback_check_name_exist_add');
			
			if($this->form_validation->run()!=false){
				$data['name']=$this->input->post('qualityname');
			
				$insert_id=$this->quality_model->insert($data);
				if($insert_id){
					$this->session->set_flashdata('msg_ok',$this->lang->line('add_successfully'));
					redirect(base_url().'admin/quality/create');					
				}
			}
		}
		$this->render_backend_tp('backends/quality/add');
	}	

	public function check_name_exist_add($phone){
		$data=$this->quality_model->get_by_name($phone);
		if ($data!=null)
		{
			$this->form_validation->set_message('check_name_exist_add', 'This Quality already exists');
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	public function check_name_exist_edit(){
		$id=$this->input->post('id');
		$name=$this->input->post('qualityname');
		$data=$this->quality_model->get_by_name_and_diff_id($id ,$name);
		if($data!=null) {
			$this->form_validation->set_message('check_name_exist_edit', 'This Quality already exists');
			return FALSE;
		} else {
			return TRUE;
		}
	}

	public function edit_get(){
		if(isset($_GET['id'])){
			$id=$this->input->get('id');
			$data['obj']=$this->quality_model->get_by_id($id);
			$this->template->write_view('content','backends/quality/edit',array('data'=>$data));
			$this->template->render();
		}
	}

	public function edit_post(){
		if(isset($_POST['id'])){
			$id=$_POST['id'];
					
			$this->form_validation->set_rules('qualityname','qualityname', 'trim|required|min_length[3]|callback_check_name_exist_edit');
			
			if($this->form_validation->run()){
				$update_data['name']=$this->input->post('qualityname');
				
				$this->quality_model->update($update_data,array('id'=>$id));
				$this->session->set_flashdata('msg_ok',$this->lang->line('edit_successfully'));
				redirect(base_url().'admin/quality/edit_get?id='.$id);
				
			}
			$data['obj']=$this->quality_model->get_by_id($id);
			$this->template->write_view('content','backends/quality/edit',array('data'=>$data));
			$this->template->render();


		}
	}

	public function delete(){
		$page=$_GET['page'];
		if(isset($_GET['id'])){
			$id=$this->input->get('id');
			$this->quality_model->remove_by_id($id);			
		}
		$this->session->set_flashdata('msg_ok',$this->lang->line('delete_successfully'));
		redirect('admin/quality'.$page);
	}

	public function activate(){
		$page=$_GET['page'];
		if(isset($_GET['id'])){
			$id=$this->input->get('id');
			$this->quality_model->update(array('activated'=>1),array('id'=>$id));
		}
		redirect('admin/quality/'.$page);
	}

	public function lock(){
		$page=$_GET['page'];
		if(isset($_GET['id'])){
			$id=$this->input->get('id');
			$this->quality_model->update(array('activated'=>0),array('id'=>$id));
		}
		redirect('admin/quality/'.$page);
	}

	
}
?>