<?php
class Orders extends MY_Controller{
	function __construct()
	{
		parent::__construct();
		if(!isset($_SESSION['user'])){
			redirect('admin/dashboard');
		}else{
			$user=$_SESSION['user'][0];
			if($user->user_type !="ADM" ){
				redirect('admin/denied');
			}
		}
		$this->load->model('users_model');
		$this->load->model('orders_model');
		$this->load->model('quality_model');
		$this->load->model('grey_model');
		$this->load->model('process_model');
		$this->load->model('bill_model');
		$this->form_validation->set_error_delimiters('<span class="help-inline msg-error" generated="true">', '</span>');
		$this->load->helper('Ultils');
		$this->panel = 'admin/';
	}

	function index(){
		
		$this->render_backend_tp('backends/orders/index');
	}

	public function ajax_list()
	{
		$list = $this->orders_model->get_datatables();
		$data = array();
		$no = $_POST['start'];
		foreach ($list as $customers) {
			$no++;
			$user_arr = $this->users_model->get_by_id($customers->userid);
			$row = array();
			$row[] = $no;
			$row[] = $customers->companyname;
			$row[] = $customers->name;
			//$row[] = "KT".$customers->id;			
			//$row[] = '<span class="label label-success">'.$customers->orderstatus.'</span>';
			$row[]='<a href="'. base_url().'admin/orders/edit_get?id='.$customers->id.'" class="btn btn-default"><i class="fa fa-edit"></i>Edit</a>';
			$row[]='<a href="'. base_url().'admin/orders/view?id='.$customers->id.'" class="btn btn-default"><i class="fa fa-windows"></i>View</a>';
			$row[]='<a href="'. base_url().'admin/grey/create?id='.$customers->id.'" class="btn btn-default"><i class="fa fa-yelp"></i>Grey</a>';
			$row[]='<a href="'. base_url().'admin/process/create?id='.$customers->id.'" class="btn btn-default"><i class="fa fa-wpexplorer"></i>Process</a>';
			$row[]='<a href="'. base_url().'admin/orders/delete?id='.$customers->id.'" class="btn btn-default" onclick="return confirm(\'Are you sure want to delete the record\')"><i class="fa fa-remove"></i>Delete</a>';
			//$row[] = $this->orders_model->get_action($customers->id,$customers->activated);

			$data[] = $row;
		}

		$output = array(
						"draw" => $_POST['draw'],
						"recordsTotal" => $this->orders_model->count_all(),
						"recordsFiltered" => $this->orders_model->count_filtered(),
						"data" => $data,
				);
		//output to json format
		echo json_encode($output);
	}

	public function view(){
		
		if(isset($_GET['id'])){
			$id=$this->input->get('id');
			$data['list']=$this->orders_model->get_by_id($id);
			$where['orderid']=$id;
			$data['orderdetails']=$this->orders_model->get_Order_details("*",$where);
			$data['greydetails']=$this->grey_model->get("*",$where);
			$data['processdetails']=$this->process_model->get("*",$where);
			$data['outwards']=$this->process_model->get_outwards("*",$where);
			$where['type']="PO";
			$data['orderuploadpo']=$this->orders_model->get_Order_uploadpo("*",$where);
			$where1['orderid']=$id;
			$data['billdetails']=$this->bill_model->get("*",$where1);
			$this->render_backend_tp('backends/orders/view',$data);		
					
		}
	}

	

public function addprocess(){
		
		if(isset($_GET['id'])){
			$id=$this->input->get('id');
			$data['list']=$this->orders_model->get_by_id($id);
			$where['orderid']=$id;
			$data['orderdetails']=$this->orders_model->get_Order_details("*",$where);		
		$where1['activated']="1";
		$where1['user_type']="SUP";
		
		$data['obj']=$this->users_model->get("*",$where1);
			
			$this->render_backend_tp('backends/orders/addprocess',$data);		
					
		}
	}
	public function create(){
		$error=null;
		$user=$_SESSION['user'][0];
		if(isset($_POST['name'])){
			$data = $_POST;	 
			
			$this->form_validation->set_rules('name','name', 'trim|required');//|callback_check_name_exist_add
			$this->form_validation->set_rules('userid','Buyer Name', 'trim|required');
			$this->form_validation->set_rules('jobtype','jobtype', 'trim|required');
			$this->form_validation->set_rules('orderconfirmfrom','orderconfirmfrom', 'trim|required');			
			$this->form_validation->set_rules('confirmdate','confirmdate', 'trim|required');	
			if($this->form_validation->run()!=false){
				$data = $_POST;	        	
	        	unset($data['quality']);
	        	unset($data['quantity']);
	        	unset($data['rate']);
	        	unset($data['description']);
	        	unset($data['width']);
	        	unset($data['ordertype']);
	        	unset($data['screencost']);
	        	unset($data['countmore']);
	        	unset($data['countlimit']);
				$data['confirmdate']=convert_time_format($_POST['confirmdate']);
				$data['orderstatus']="New";	

				$data['useradd']=$user->id;  
				   		        	
				$insert_id=$this->orders_model->insert($data);
				$udata['ordernumber']="KT".$insert_id;
				$uid=$this->orders_model->update($udata,array('id'=>$insert_id));
				if($insert_id!=0){
					//image Upload
					if(isset($_FILES['image']) && !empty($_FILES['image']['name'])){
						$config=array();
						$dir='uploads/poupload';
						$filename=$_FILES['image']['name'];
						$config['allowed_types'] = '*';
						$config['upload_path']=$dir;
						$this->load->library('upload',$config);
						$data_img = array();
						foreach ($_FILES['image']['name'] as $key => $value) {
							$nmarr[] = rename_upload_file($value);
						}if ($this->upload->do_multi_upload('image',TRUE,$nmarr))
						{
							
							foreach ($nmarr as $key => $value) {
								$data_img['file']=$dir.'/'.$value;
								$data_img['orderid']=$insert_id;
								$data_img['type']="PO";						
								$this->orders_model->insert_orderuploadpo($data_img);

							}					
							
						}else{
							$this->session->set_flashdata('msg_error', $this->upload->display_errors());							
						}
					}
					$quality=$_POST['quality'];
					$quantity=$_POST['quantity'];
					$rate=$_POST['rate'];
					$width=$_POST['width'];
					$description=$_POST['description'];
					$ordertype=$_POST['ordertype'];
					$screencost=$_POST['screencost'];
					foreach($quality as $detkey=>$detval)
					{
						$odata['quality']=$detval;
						$odata['quantity']=$quantity[$detkey];
						$odata['rate']=$rate[$detkey];
						$odata['width']=$width[$detkey];
						$odata['description']=$description[$detkey];
						$odata['ordertype']=$ordertype[$detkey];
						$odata['screencost']=$screencost[$detkey];
						$odata['useradd']=$user->id; 
						$odata['orderid']=$insert_id;							
						if($odata['quality']!=""&&$odata['quantity']!=""&&$odata['rate']!=""&&$odata['description']!=""&&$odata['ordertype']!=""&&$odata['width']!="")
						{
						  $insert_id_details=$this->orders_model->insert_orderdetails($odata);	
						}

					}
					
					$this->session->set_flashdata('msg_ok',$this->lang->line('add_successfully'));
					redirect(base_url().'admin/orders/create');
				}
			}
		}
		$where['user_type']="BUY";
		$where['activated']="1";
		$data['obj']=$this->users_model->get("*",$where);
		$data['Quality']=$this->quality_model->get("*",array());
		$this->render_backend_tp('backends/orders/add',$data);
	}

	public function check_name_exist_add($name){
		$data=$this->orders_model->get_by_exact_name($name);
		if ($data!=null)
		{
			$this->form_validation->set_message('check_name_exist_add', 'This Order name has exist');
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}


	public function check_name_exist_edit(){
		$id=$this->input->post('id');
		$name=$this->input->post('name');
		$data=$this->orders_model->get_by_name_and_diff_id($id,$name);
		if($data!=null) {
			$this->form_validation->set_message('check_name_exist_edit', 'This Order name has exist');
			return FALSE;
		} else {
			return TRUE;
		}
	}	

	public function edit_get(){
		if(isset($_GET['id'])){
		$id=$this->input->get('id');
		$where['user_type']="BUY";
		$where['activated']="1";
		$data['users']=$this->users_model->get("*",$where);
		$data['Quality']=$this->quality_model->get("*",array());
		$data['obj']=$this->orders_model->get_by_id($id);
		$owhere['orderid']=$id;
		$data['orderdetails']=$this->orders_model->get_Order_details("*",$owhere);
		$data['imagearray']=$this->orders_model->get_image("*",array("orderid"=>$id,"type"=>"PO"));
		$this->template->write_view('content','backends/orders/edit',array('data'=>$data));
		$this->template->render();
		}
	}

	public function edit_post(){
		$user=$_SESSION['user'][0];
		if(isset($_POST['id'])){
			$id=$_POST['id'];
			$data = $_POST;	 
			
			$this->form_validation->set_rules('name','name', 'trim|required');//|callback_check_name_exist_add
			$this->form_validation->set_rules('userid','Buyer Name', 'trim|required');
			$this->form_validation->set_rules('jobtype','jobtype', 'trim|required');
			$this->form_validation->set_rules('orderconfirmfrom','orderconfirmfrom', 'trim|required');			
			$this->form_validation->set_rules('confirmdate','confirmdate', 'trim|required');	
			if($this->form_validation->run()!=false){
				$data = $_POST;	        	
	        	$removedata=$_POST['removeimage'];        	
	        	unset($data['quality']);
	        	unset($data['quantity']);
	        	unset($data['rate']);
	        	unset($data['width']);
	        	unset($data['description']);
	        	unset($data['ordertype']);
	        	unset($data['screencost']);
	        	unset($data['countmore']);
	        	unset($data['countlimit']);
	        	unset($data['removeimage']);unset($data['oid']);
				$data['confirmdate']=convert_time_format($_POST['confirmdate']); 		
				$insert_id=$this->orders_model->update($data,array('id'=>$id));
				
					//image Upload
				//image Upload
				if($removedata)
				{
					foreach($removedata as $key=>$value)
					{
						
						$removeid=$this->orders_model->remove_orderuploadpo(array('id'=>$value,'type'=>"PO"));
					}
				}
					if(isset($_FILES['image']) && !empty($_FILES['image']['name'])){
						$config=array();
						$dir='uploads/poupload';
						$filename=$_FILES['image']['name'];
						$config['allowed_types'] = '*';
						$config['upload_path']=$dir;
						$this->load->library('upload',$config);
						$data_img = array();
						foreach ($_FILES['image']['name'] as $key => $value) {
							$nmarr[] = rename_upload_file($value);
						}
						if ($this->upload->do_multi_upload('image',TRUE,$nmarr))
						{
							
							foreach ($nmarr as $key => $value) {
								$data_img['file']=$dir.'/'.$value;
								$data_img['orderid']=$insert_id;
								$data_img['type']="PO";						
								$this->orders_model->insert_orderuploadpo($data_img);

							}					
							
						}else{
							$this->session->set_flashdata('msg_error', $this->upload->display_errors());							
						}
					}
					$quality=$_POST['quality'];
					$quantity=$_POST['quantity'];
					$rate=$_POST['rate'];
					$width=$_POST['width'];
					$description=$_POST['description'];
					$ordertype=$_POST['ordertype'];
					$screencost=$_POST['screencost'];
					$oid=$_POST['oid'];
					
					foreach($quality as $detkey=>$detval)
					{
						$odata['quality']=$detval;
						$odata['quantity']=$quantity[$detkey];
						$odata['rate']=$rate[$detkey];
						$odata['width']=$width[$detkey];
						$odata['description']=$description[$detkey];
						$odata['ordertype']=$ordertype[$detkey];
						$odata['screencost']=$screencost[$detkey];
						$odata['useradd']=$user->id; 
						$odata['orderid']=$id;	
						$orderdetails=$oid[$detkey];						
						if($odata['quality']!=""&&$odata['quantity']!=""&&$odata['rate']!=""&&$odata['description']!=""&&$odata['ordertype']!=""&&$odata['width']!="")
						{
						 if($orderdetails != "")
						 	$insert_id=$this->orders_model->update_orderdetails($odata,array("id"=>$orderdetails));
						 else
						  $insert_id=$this->orders_model->insert_orderdetails($odata);	
						}

					}
					
					$this->session->set_flashdata('msg_ok',$this->lang->line('edit_successfully'));
					redirect(base_url().'admin/orders');
				}
			
		}
		$where['user_type']="BUY";
		$where['activated']="1";
		$data['users']=$this->users_model->get("*",$where);
		$data['Quality']=$this->quality_model->get("*",array());
		$data['obj']=$this->orders_model->get_by_id($id);
		$this->template->write_view('content','backends/orders/edit',array('data'=>$data));
		$this->template->render();


		
	}

	public function delete(){
		if(isset($_GET['id'])){
			$id=$this->input->get('id');
			$user=$this->orders_model->get_by_id($id);
			$this->orders_model->remove_by_id($id);
			$this->session->set_flashdata('msg_ok',$this->lang->line('delete_successfully'));
		}

		redirect('admin/orders');
	}

	public function activate(){
				if(isset($_GET['id'])){
			$id=$this->input->get('id');
			$this->orders_model->update(array('activated'=>1),array('id'=>$id));
			$this->session->set_flashdata('msg_ok','activated_successfully');
		}
		redirect('admin/orders');
	}

	public function lock(){		
		if(isset($_GET['id'])){
			$id=$this->input->get('id');
			$this->orders_model->update(array('activated'=>0),array('id'=>$id));
			$this->session->set_flashdata('msg_ok','deactivated_successfully');
		}
		redirect('admin/orders');
	}

	
}
?>