<?php
class Dashboard extends MY_Controller{
	function __construct()
	{
		parent::__construct();		
		$this->form_validation->set_error_delimiters('<div class="error-line msg-error">', '</div>');
		$this->load->helper('Ultils');
		$this->panel = 'admin';		
		$this->load->model('users_model');
		$this->load->model('orders_model');
		$this->load->model('payment_model');
		$this->load->model('quality_model');
		$this->load->model('grey_model');
		$this->load->model('process_model');
		$this->load->model('voucher_model');
		$this->load->model('bill_model');
		
	}
	
	function index(){
		
		if(!isset($_SESSION['user']) || $_SESSION['user']==null){
			$this->load->view('backends/login');
		}else{
			########Count
			$data["usercount"]=$this->bill_model->count_all();	
			$data["totalcount"]=$this->bill_model->count_all_amount();
			$data["ordercount"]=$this->orders_model->count_all();
			$array_where["voucher.type"]="payment";
			$array_where["voucher.pay_type"]="debit";
			$data["paymentcount"]=$this->payment_model->sum_all($array_where);	
			$array_where1["voucher.type"]="receipt";
			$array_where1["voucher.pay_type"]="credit";
			$data["receiptcount"]=$this->payment_model->sum_all($array_where1);	
			#############SUpplier Payment
			$data["totalpayment"]=$this->payment_model->get_report("*",$array_where,"payment.userid");
			foreach($data["totalpayment"] as $key=>$value)
			{				
				$where = array('voucher.type'=>"payment",'voucher.pay_type'=>"debit",'payment.userid'=>$value->user_id);
				$debit=$this->payment_model->sum_all($where);
				$value->debit=$debit[0]["amount"];
				$where = array('voucher.type'=>"payment",'voucher.pay_type'=>"credit",'payment.userid'=>$value->user_id);
				$credit=$this->payment_model->sum_all($where);
				$value->credit=$credit[0]["amount"];	
			}

			#############Buyer Receipt
			$data["totalreceipt"]=$this->payment_model->get_report("*",$array_where1,"payment.userid");
			foreach($data["totalreceipt"] as $key=>$value)
			{				
				$where = array('voucher.type'=>"receipt",'voucher.pay_type'=>"debit",'payment.userid'=>$value->user_id);
				$debit=$this->payment_model->sum_all($where);
				$value->debit=$debit[0]["amount"];
				$where = array('voucher.type'=>"receipt",'voucher.pay_type'=>"credit",'payment.userid'=>$value->user_id);
				$credit=$this->payment_model->sum_all($where);
				$value->credit=$credit[0]["amount"];	
			}	
			####Bill
			$data['billdetails']=$this->bill_model->get("*",array(),array(),0,5,array("billno"=>"desc"));
			$this->render_backend_tp('backends/dashboard',$data);
		}
	}

	/*function print(){	
		$this->load->view('backends/print');
	}*/

	function login(){
		if(isset($_POST['user_email']) && isset($_POST['pwd'])){
			$pass_data=null;
			$this->form_validation->set_rules('user_email','phone', 'trim|required|min_length[5]|max_length[60]');			
			$this->form_validation->set_rules('pwd','password', 'trim|required');
			if($this->form_validation->run()!=false){
				$user_email=$_POST['user_email'];
				$pwd=$_POST['pwd'];
				$this->load->model('users_model');
				$this->load->helper('ultils');
				$data=$this->users_model->get_by_phone_and_pwd($user_email,encrypt_pwd($pwd));
				if($data){
					$_SESSION["user"]=$data;					
					redirect('admin/dashboard');
				}else{
					$pass_data['error_msg']='<div class="help-block">Wrong password or username, try again</div>';
				}
			}
			$this->load->view('backends/login',$pass_data);
		}else{
			redirect('admin/dashboard');
		}
	}

	function logout(){
		if(isset($_SESSION['user'])){
			unset($_SESSION['user']);
			redirect('admin/dashboard');
		}else{
			redirect('admin/dashboard');
		}
	}
	public function check_phone_exist_edit(){
		$id=$this->input->post('id');
		$name=$this->input->post('phone');
		$data=$this->users_model->get_by_phone_and_diff_id($id,$name);
		if($data!=null) {
			$this->form_validation->set_message('check_phone_exist_edit', 'This Phone number has exist');
			return FALSE;
		} else {
			return TRUE;
		}
	}

	public function update_profile(){
		$user=$_SESSION['user'][0];		
		if(isset($_POST['id'])){
			 $id=$_POST['id'];
			$this->form_validation->set_rules('phone','phone', 'trim|required|min_length[10]|max_length[10]|callback_check_phone_exist_edit');			
			$this->form_validation->set_rules('full_name','Name', 'trim|required|max_length[60]');			
			$this->form_validation->set_rules('companyname','Company name', 'trim|required|max_length[60]');
			if($this->form_validation->run()){
				$update_data = $_POST;	        	
				$this->users_model->update($update_data,array('id'=>$id));
				$this->session->set_flashdata('msg_ok',$this->lang->line('edit_successfully'));
				redirect('admin/dashboard/update_profile');
			}
			


		}else{
			$data['obj']=$this->users_model->get_by_id($user->id);			
			$this->template->write_view('content','backends/users/update_profile',array('data'=>$data));
			$this->template->render();
		}
	}

	public function update_pwd(){
		if(isset($_SESSION['user'])){
			$user=$_SESSION['user'][0];
			$this->form_validation->set_rules('old_pwd','old password', 'trim|required|xss_clean');
			$this->form_validation->set_rules('new_pwd','new password', 'trim|required|xss_clean');
			$this->form_validation->set_rules('cfm_pwd','confirm password', 'trim|required|xss_clean|callback_check_equal_less['.$this->input->post('new_pwd').']');
			if($this->form_validation->run()){
				$old_pwd=$this->input->post('old_pwd');
				if(encrypt_pwd($old_pwd)!=$user->pwd){
					$data['error_msg']="Your old password incorrect, updated failed";
				}else{
					$new_pwd=$this->input->post('new_pwd');
					$update_data['pwd']=encrypt_pwd($new_pwd);
					$this->users_model->update($update_data,array('id'=>$user->id));
					$data['success_msg']="Update success";
				}
			}
			$data['obj']=$this->users_model->get_by_id($user->id);
			$this->template->write_view('content','backends/users/update_pwd',$data);
			$this->template->render();
		}else{
			redirect('admin/dashboard');
		}
	}

	function check_equal_less($second_field,$first_field)
	{
		$new_pwd=$this->input->post('new_pwd');
		$cfm_pwd=$this->input->post('cfm_pwd');
		if ($new_pwd!=$cfm_pwd)
		{
			$this->form_validation->set_message('check_equal_less', 'The confirm password need the same confirm password');
			return false;       
		}
		else
		{
			return true;
		}
	}

	function settings(){
		$this->load->helper('settings');
	}

	function mail(){
		$this->load->helper('email_ultils');
		//send_verified_mail("álkdjsad","luann4099@gmail.com");
		send_enquiry();
	}

	function dbchange(){
		if(isset($_GET['id'])){
			$id=$this->input->get('id');
			$ci = & get_instance();
			$ci->load->library('session');
			$ci->session->set_userdata('clientdb',$id);
			redirect('admin/dashboard');
		}

	}
}
?>