<?php
class Receipt extends MY_Controller{
	function __construct()
	{
		parent::__construct();
		if(!isset($_SESSION['user'])){
			redirect('admin/dashboard');
		}else{
			$user=$_SESSION['user'][0];
			if($user->user_type !="ADM" ){
				redirect('admin/denied');
			} 
		}
		$this->load->model('users_model');
		$this->load->model('orders_model');
		$this->load->model('receipt_model');
		$this->load->model('quality_model');
		$this->load->model('grey_model');
		$this->load->model('process_model');
		$this->load->model('voucher_model');
		$this->form_validation->set_error_delimiters('<span class="help-inline msg-error" generated="true">', '</span>');
		$this->load->helper('Ultils');
		$this->panel = 'admin/';
	}

	function index(){
		
		$this->render_backend_tp('backends/receipt/index');
	}

	public function ajax_list()
	{
		$list = $this->receipt_model->get_datatables();
		$data = array();
		$no = $_POST['start'];
		foreach ($list as $customers) {
			$no++;
			
			$row = array();
			$row[] = $no;
			$row[] = '<a href="'. base_url().'admin/payment/report?id='.$customers->userid.'" class="btn btn-default">'.$customers->companyname.'</a>';
			$row[] = convert_money($customers->amount);
			$row[] = revert_time_format($customers->billdate);		
			$row[] = $customers->vouchername;	
			//$row[] = '<span class="label label-success">'.$customers->orderstatus.'</span>';

			$row[] = $this->receipt_model->get_action($customers->id,$customers->activated);

			$data[] = $row;
		}

		$output = array(
						"draw" => $_POST['draw'],
						"recordsTotal" => $this->receipt_model->count_all(),
						"recordsFiltered" => $this->receipt_model->count_filtered(),
						"data" => $data,
				);
		//output to json format
		echo json_encode($output);
	}

	public function view(){
		
		if(isset($_GET['id'])){
			$id=$this->input->get('id');
			$data['list']=$this->receipt_model->get_by_id($id);
			$where['user_type']="BUY";
			$where['activated']="1";
			$data['obj']=$this->users_model->get("*",$where);
			$data['Quality']=$this->quality_model->get("*",array());
			$where1['type']="receipt";
			$where1["id<>"]=1;
			$data['Voucher']=$this->voucher_model->get("*",$where1);
			$this->render_backend_tp('backends/receipt/view',$data);
					
		}
	}

	


	public function create(){
		$error=null;
		$user=$_SESSION['user'][0];
		if(isset($_POST['name'])){
			$data = $_POST;	 
			
			$this->form_validation->set_rules('name','name', 'trim|required');//|callback_check_name_exist_add
			$this->form_validation->set_rules('userid','Buyer Name', 'trim|required');
			$this->form_validation->set_rules('voucher_id','Voucher Type', 'trim|required');
			$this->form_validation->set_rules('amount','amount', 'trim|numeric|required');
			$this->form_validation->set_rules('billdate','billdate', 'trim|required');			
			
			if($this->form_validation->run()!=false){
				$data = $_POST;
				$data['billdate']=convert_time_format($_POST['billdate']);	
				$data['useradd']=$user->id; 
				$insert_id=$this->receipt_model->insert($data);
				
				
					
					$this->session->set_flashdata('msg_ok',$this->lang->line('add_successfully'));
					redirect(base_url().'admin/receipt/create');
				}
			}
		
		$where['user_type']="BUY";
		$where['activated']="1";
		$data['obj']=$this->users_model->get("*",$where);
		$data['Quality']=$this->quality_model->get("*",array());
		$where1['type']="receipt";
		$where1["id<>"]=1;
		$data['Voucher']=$this->voucher_model->get("*",$where1);
		$this->render_backend_tp('backends/receipt/add',$data);
	}

	public function check_name_exist_add($name){
		$data=$this->receipt_model->get_by_exact_name($name);
		if ($data!=null)
		{
			$this->form_validation->set_message('check_name_exist_add', 'This Order name has exist');
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}


	public function check_name_exist_edit(){
		$id=$this->input->post('id');
		$name=$this->input->post('name');
		$data=$this->receipt_model->get_by_name_and_diff_id($id,$name);
		if($data!=null) {
			$this->form_validation->set_message('check_name_exist_edit', 'This Order name has exist');
			return FALSE;
		} else {
			return TRUE;
		}
	}	

	public function edit_get(){
		if(isset($_GET['id'])){
		$id=$this->input->get('id');
		$where['user_type']="BUY";
		$where['activated']="1";
		$data['users']=$this->users_model->get("*",$where);
		
		$data['obj']=$this->receipt_model->get_by_id($id);
		$where1['type']="receipt";
		$where1["id<>"]=1;
		$data['Voucher']=$this->voucher_model->get("*",$where1);
		
		$this->template->write_view('content','backends/receipt/edit',array('data'=>$data));
		$this->template->render();
		}
	}

	public function edit_post(){
		$user=$_SESSION['user'][0];
		if(isset($_POST['id'])){
			$id=$_POST['id'];
			$data = $_POST;	 
			
			$this->form_validation->set_rules('name','name', 'trim|required');//|callback_check_name_exist_add
			$this->form_validation->set_rules('userid','Buyer Name', 'trim|required');
			$this->form_validation->set_rules('amount','amount', 'trim|numeric|required');
					
			$this->form_validation->set_rules('billdate','billdate', 'trim|required');	
			if($this->form_validation->run()!=false){
				$data = $_POST;	        	
	        	
				$data['billdate']=convert_time_format($_POST['billdate']); 		
				$insert_id=$this->receipt_model->update($data,array('id'=>$id));
					
					$this->session->set_flashdata('msg_ok',$this->lang->line('edit_successfully'));
					redirect(base_url().'admin/receipt');
				}
			
		}
		$where['user_type']="BUY";
		$where['activated']="1";
		$data['users']=$this->users_model->get("*",$where);	
		$where1['type']="receipt";
		$where1["id<>"]=1;
		$data['Voucher']=$this->voucher_model->get("*",$where1);	
		$data['obj']=$this->receipt_model->get_by_id($id);
		$this->template->write_view('content','backends/receipt/edit',array('data'=>$data));
		$this->template->render();


		
	}

	public function delete(){
		if(isset($_GET['id'])){
			$id=$this->input->get('id');
			$user=$this->receipt_model->get_by_id($id);
			$this->receipt_model->remove_by_id($id);
			$this->session->set_flashdata('msg_ok',$this->lang->line('delete_successfully'));
		}

		redirect('admin/receipt');
	}

	public function activate(){
				if(isset($_GET['id'])){
			$id=$this->input->get('id');
			$this->receipt_model->update(array('activated'=>1),array('id'=>$id));
			$this->session->set_flashdata('msg_ok','activated_successfully');
		}
		redirect('admin/receipt');
	}

	public function lock(){		
		if(isset($_GET['id'])){
			$id=$this->input->get('id');
			$this->receipt_model->update(array('activated'=>0),array('id'=>$id));
			$this->session->set_flashdata('msg_ok','deactivated_successfully');
		}
		redirect('admin/receipt');
	}

	
}
?>