<?php
class Users extends MY_Controller{
	function __construct()
	{
		parent::__construct();
		if(!isset($_SESSION['user'])){
			redirect('admin/dashboard');
		}else{
			$user=$_SESSION['user'][0];
			if($user->user_type !="ADM" ){
				redirect('admin/denied');
			}
		}
		$this->load->model('users_model');
		$this->load->model('orders_model');
		$this->load->model('quality_model');
		$this->form_validation->set_error_delimiters('<span class="help-inline msg-error" generated="true">', '</span>');
		$this->load->helper('Ultils');
		$this->panel = 'admin';
	}

	function index(){
		
		$this->render_backend_tp('backends/users/index');
	}

	public function ajax_list()
	{
		$list = $this->users_model->get_datatables();
		$data = array();
		$no = $_POST['start'];
		foreach ($list as $customers) {
			$no++;
			$row = array();
			$row[] = $no;
			$row[] = $customers->companyname;
			//$row[] = $customers->full_name;
			$row[] = USERTYPEARRAY[$customers->user_type];
			//$row[] = $customers->phone;
			$row[] = $this->users_model->get_action($customers->id,$customers->activated);

			$data[] = $row;
		}

		$output = array(
						"draw" => $_POST['draw'],
						"recordsTotal" => $this->users_model->count_all(),
						"recordsFiltered" => $this->users_model->count_filtered(),
						"data" => $data,
				);
		//output to json format
		echo json_encode($output);
	}

	public function view(){
		
		if(isset($_GET['id'])){
			$id=$this->input->get('id');
			$data['list']=$this->users_model->get_by_id($id);			
			$this->load->view("backends/users/view", $data);			
		}
	}

	public function create(){
		$error=null;
		if(isset($_POST['user_type'])){
			$this->form_validation->set_rules('phone','phone', 'trim|required|min_length[10]|max_length[10]|callback_check_phone_exist_add');
			$this->form_validation->set_rules('pwd','password', 'trim|required|min_length[5]|max_length[60]');
			$this->form_validation->set_rules('confirmpassword','password', 'trim|required|min_length[5]|max_length[60]|callback_check_equal_less');
			$this->form_validation->set_rules('full_name','Name', 'trim|required|max_length[60]');			
			$this->form_validation->set_rules('companyname','Company name', 'trim|required|max_length[60]');	
			if($this->form_validation->run()!=false){
				$data = $_POST;	        	
	        	unset($data['confirmpassword']);
				$data['pwd']=encrypt_pwd($_POST['pwd']);	        		        	
				$insert_id=$this->users_model->insert($data);
				if($insert_id!=0){
					$this->session->set_flashdata('msg_ok',$this->lang->line('add_successfully'));
					redirect(base_url().'admin/users/create');
				}
			}
		}
		$this->render_backend_tp('backends/users/add');
	}

	function check_equal_less()
	{
		$new_pwd=$this->input->post('pwd');
		$cfm_pwd=$this->input->post('confirmpassword');
		if ($new_pwd!=$cfm_pwd)
		{
			$this->form_validation->set_message('check_equal_less', 'The confirm password need the same password');
			return false;       
		}
		else
		{
			return true;
		}
	}

	public function check_phone_exist_add($name){
		$data=$this->users_model->get_by_exact_phone($name);
		if ($data!=null)
		{
			$this->form_validation->set_message('check_phone_exist_add', 'This Phone number has exist');
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}


	public function check_phone_exist_edit(){
		$id=$this->input->post('id');
		$name=$this->input->post('phone');
		$data=$this->users_model->get_by_phone_and_diff_id($id,$name);
		if($data!=null) {
			$this->form_validation->set_message('check_phone_exist_edit', 'This Phone number has exist');
			return FALSE;
		} else {
			return TRUE;
		}
	}	

	public function edit_get(){
		if(isset($_GET['id'])){
			$id=$this->input->get('id');
			$data['obj']=$this->users_model->get_by_id($id);
			$this->template->write_view('content','backends/users/edit',array('data'=>$data));
			$this->template->render();
		}
	}

	public function edit_post(){
		if(isset($_POST['id'])){
			$id=$_POST['id'];
			$this->form_validation->set_rules('phone','phone', 'trim|required|min_length[10]|max_length[10]|callback_check_phone_exist_edit');			
			$this->form_validation->set_rules('full_name','Name', 'trim|required|max_length[60]');			
			$this->form_validation->set_rules('companyname','Company name', 'trim|required|max_length[60]');
			if($this->form_validation->run()){
				$update_data = $_POST;	        	
				$this->users_model->update($update_data,array('id'=>$id));
				$this->session->set_flashdata('msg_ok',$this->lang->line('edit_successfully'));
				redirect(base_url().'admin/users/edit_get?id='.$id);
			}
			$data['obj']=$this->users_model->get_by_id($id);
			$this->template->write_view('content','backends/users/edit',array('data'=>$data));
			$this->template->render();


		}
	}

	public function delete(){
		if(isset($_GET['id'])){
			$id=$this->input->get('id');
			$user=$this->users_model->get_by_id($id);
			$this->users_model->remove_by_id($id);
			$this->session->set_flashdata('msg_ok',$this->lang->line('delete_successfully'));
		}

		redirect('admin/users');
	}

	public function activate(){
				if(isset($_GET['id'])){
			$id=$this->input->get('id');
			$this->users_model->update(array('activated'=>1),array('id'=>$id));
			$this->session->set_flashdata('msg_ok','activated_successfully');
		}
		redirect('admin/users');
	}

	public function lock(){		
		if(isset($_GET['id'])){
			$id=$this->input->get('id');
			$this->users_model->update(array('activated'=>0),array('id'=>$id));
			$this->session->set_flashdata('msg_ok','deactivated_successfully');
		}
		redirect('admin/users');
	}

	
}
?>