<?php
class Bill extends MY_Controller{
	function __construct()
	{
		parent::__construct();
		if(!isset($_SESSION['user'])){
			redirect('admin/dashboard');
		}else{
			$user=$_SESSION['user'][0];
			if($user->user_type !="ADM" ){
				redirect('admin/denied');
			}
		}
		$this->load->model('users_model');
		$this->load->model('orders_model');
		$this->load->model('quality_model');
		$this->load->model('grey_model');
		$this->load->model('bill_model');
		$this->load->model('payment_model');
		$this->form_validation->set_error_delimiters('<span class="help-inline msg-error" generated="true">', '</span>');
		$this->load->helper('Ultils');
		$this->panel = 'admin/';
	}

	function index(){
		
		$this->render_backend_tp('backends/bill/index');
	}

	public function ajax_list()
	{
		$list = $this->bill_model->get_datatables();
		$data = array();
		$no = $_POST['start'];
		foreach ($list as $customers) {
			$no++;
			$user_arr = $this->users_model->get_by_id($customers->userid);
			$row = array();
			$row[] = $customers->billno;
			$row[] = $customers->billdate;
			$row[] = $customers->companyname;
			$row[] = $customers->name;
			$row[] = $customers->grandtotal;			
			//$row[] = '<span class="label label-success">'.$customers->orderstatus.'</span>';
			$row[]='<a href="'. base_url().'admin/bill/invoice?orderid='.$customers->orderid.'&billid='.$customers->id.'" class="btn btn-default" target="_blank"><i class="fa fa-print"></i>Print</a>';
			$row[]='<a href="'. base_url().'admin/bill/edit_get?orderid='.$customers->orderid.'&billid='.$customers->id.'" class="btn btn-default"><i class="fa fa-edit"></i>Edit</a>';
			$row[]='<a href="'. base_url().'admin/bill/view?orderid='.$customers->orderid.'&billid='.$customers->id.'" class="btn btn-default"><i class="fa fa-windows"></i>View</a>';
			$row[]='<a href="'. base_url().'admin/bill/delete?orderid='.$customers->orderid.'&billid='.$customers->id.'" class="btn btn-default" onclick="return confirm(\'Are you sure want to delete the record\')"><i class="fa fa-remove"></i>Delete</a>';
			//$row[] = $this->bill_model->get_action($customers->id,$customers->activated,$customers->orderid);

			$data[] = $row;
		}

		$output = array(
						"draw" => $_POST['draw'],
						"recordsTotal" => $this->bill_model->count_all(),
						"recordsFiltered" => $this->bill_model->count_filtered(),
						"data" => $data,
				);
		//output to json format
		echo json_encode($output);
	}

	public function view(){
		
		if(isset($_GET['orderid'])){
			$orderid=$this->input->get('orderid');
			$billid=$this->input->get('billid');
			$data['list']=$this->orders_model->get_by_id($orderid);
			$where['orderid']=$orderid;
			$data['orderdetails']=$this->orders_model->get_Order_details("*",$where);
			$data['bill']=$this->bill_model->get_by_id($billid);
			$where1['billid']=$billid;
			$data['billdetails']=$this->bill_model->get_bill_details("*",$where1);
			//echo "<pre>"; print_r($data); echo "</pre>";
			$this->render_backend_tp('backends/bill/view',$data);		
					
		}
	}

	public function invoice(){
		
		if(isset($_GET['orderid'])){
			$orderid=$this->input->get('orderid');
			$billid=$this->input->get('billid');
			$data['list']=$this->orders_model->get_by_id($orderid);
			$where['orderid']=$orderid;
			$data['orderdetails']=$this->orders_model->get_Order_details("*",$where);
			$data['bill']=$this->bill_model->get_by_id($billid);
			$where1['billid']=$billid;
			$data['billdetails']=$this->bill_model->get_bill_details("*",$where1);
			$user=$_SESSION['user'][0];	
			$data['company']=$this->users_model->get_by_id($user->id);
	        //echo "<pre>"; print_r($data); echo "</pre>";exit;
			$this->load->view('backends/bill/invoice',$data);		
					
		}
	}

	public function invoiceall(){
		$list = $this->bill_model->get_datatables();
		$data['all']=$list;
		foreach ($list as $customers) {

			$orderid=$customers->orderid;
			$billid=$customers->id;
			$data['list'][$billid]=$this->orders_model->get_by_id($orderid);
			$where['orderid']=$orderid;
			$data['orderdetails'][$billid]=$this->orders_model->get_Order_details("*",$where);
			$data['bill'][$billid]=$this->bill_model->get_by_id($billid);
			$where1['billid']=$billid;
			$data['billdetails'][$billid]=$this->bill_model->get_bill_details("*",$where1);
			$user=$_SESSION['user'][0];	
			$data['company'][$billid]=$this->users_model->get_by_id($user->id);
			
					
		}
		
				
				foreach($data as $key => $value)
                {
					//echo $company[0][$value->id]->address;	
				//echo "<pre>"; print_r($value); echo "</pre>";
					
					}
					//exit;
		//$this->load->view('backends/bill/invoiceall',$data);	
		$this->render_backend_tp('backends/bill/invoiceall',$data);	
	}

	public function create(){
		$error=null;
		$user=$_SESSION['user'][0];
		if(isset($_POST['billno'])){
			$data = $_POST;	 
			
			$this->form_validation->set_rules('billdate','billdate', 'trim|required');//|callback_check_name_exist_add
				
			if($this->form_validation->run()!=false){
				$data = $_POST;	        	
	        	unset($data['orderdetailsid']);
	        	unset($data['quantity']);
	        	unset($data['rate']);
	        	unset($data['description']);
	        	unset($data['width']);
	        	unset($data['totalpiece']);
	        	unset($data['countmore']);
	        	unset($data['countlimit']);
	        	unset($data['orderselect']);
	        	
	        	
				$data['billdate']=convert_time_format($_POST['billdate']);	
				$data['useradd']=$user->id; 
				$insert_id=$this->bill_model->insert($data);
				if($insert_id!=0){
					
					$orderdetailsid=$_POST['orderdetailsid'];
					$quantity=$_POST['quantity'];
					$rate=$_POST['rate'];
					$description=$_POST['description'];
					$width=$_POST['width'];
					$totalpiece=$_POST['totalpiece'];
					$cgst=0;$sgst=0;$subtotal=0;
					foreach($orderdetailsid as $detkey=>$detval)
					{
						$odata['orderdetailsid']=$detval;
						$odata['quantity']=$quantity[$detkey];
						$odata['rate']=$rate[$detkey];
						$odata['description']=$description[$detkey];
						$odata['totalpiece']=$totalpiece[$detkey];
						$odata['width']=$width[$detkey];
						//$odata['useradd']=$user->id; 
						$odata['billid']=$insert_id;
						$odata['orderid']=$data['orderid'];	
						$odata['totalamount']=$odata['quantity']*$odata['rate'];
						$odata['cgst']=$odata['sgst']=$odata['igst']=0;
						if($data['gst']=="0"){
						$odata['cgst']=number_format((float)(($odata['totalamount']*CONST_CGST)/100), 2, '.', '');
						$odata['sgst']=number_format((float)(($odata['totalamount']*CONST_SGST)/100), 2, '.', '');
							}
						if($data['gst']=="2"){
						$odata['cgst']=number_format((float)(($odata['totalamount']*CONST_CGST9)/100), 2, '.', '');
						$odata['sgst']=number_format((float)(($odata['totalamount']*CONST_SGST9)/100), 2, '.', '');
							}
						if($data['gst']=="1")
						$odata['igst']=number_format((float)(($odata['totalamount']*CONST_IGST)/100), 2, '.', '');
						


						if($odata['orderdetailsid']!=""&&$odata['quantity']!=""&&$odata['rate']!="")
						{
						  $bdetils=$this->bill_model->insert_billdetails($odata);	
						$cgst += $odata['cgst'];
						$sgst += $odata['sgst'];
						$igst += $odata['igst'];
						$subtotal += $odata['totalamount'];
						}
					}
					$screencgst=$screensgst=$screenigst=0;
					$transcgst=$transsgst=$transigst=0;
					if($data['screencost'] != "")
					{
						if($data['gst']=="0"){
						$screencgst=number_format((float)(($data['screencost']*CONST_CGST)/100), 2, '.', '');
						$screensgst=number_format((float)(($data['screencost']*CONST_SGST)/100), 2, '.', '');
						}
					if($data['gst']=="2"){
						$screencgst=number_format((float)(($data['screencost']*CONST_CGST9)/100), 2, '.', '');
						$screensgst=number_format((float)(($data['screencost']*CONST_SGST9)/100), 2, '.', '');
						}
						if($data['gst']=="1")
						$screenigst=number_format((float)(($data['screencost']*CONST_IGST)/100), 2, '.', '');
					} else $data['screencost']=0;
					if($data['transportcharge'] != "")
					{
						if($data['gst']=="0"){
						$transcgst=number_format((float)(($data['transportcharge']*CONST_CGST)/100), 2, '.', '');
						$transsgst=number_format((float)(($data['transportcharge']*CONST_SGST)/100), 2, '.', '');
					}
					if($data['gst']=="2"){
						$transcgst=number_format((float)(($data['transportcharge']*CONST_CGST9)/100), 2, '.', '');
						$transsgst=number_format((float)(($data['transportcharge']*CONST_SGST9)/100), 2, '.', '');
					}
						if($data['gst']=="1")
						$transigst=number_format((float)(($data['transportcharge']*CONST_IGST)/100), 2, '.', '');
					} else $data['transportcharge']=0;

					
					$udata['cgst']=number_format($cgst+$screencgst+$transcgst, 2, '.', '');
					$udata['sgst']=number_format($sgst+$screensgst+$transsgst, 2, '.', '');
					$udata['igst']=number_format($igst+$screenigst+$transigst, 2, '.', '');
					$udata['subtotal']=number_format($subtotal, 2, '.', '');
					$grandtotal=$subtotal+$udata['cgst']+$udata['sgst']+$udata['igst']+$data['screencost']+$data['transportcharge'];
					$grandtotal=number_format($grandtotal, 2, '.', '');
					$whole = floor($grandtotal);      // 1
					$fraction = $grandtotal - $whole; // .25
					if($fraction == 00)
					{
						$udata['grandtotal']=$whole;
						$udata['roundoff']=0;
					}
					elseif($fraction >= .50)
					{
						$udata['grandtotal']=$whole+1;
						$udata['roundoff']=1-$fraction;
					}
					else
					{
						$udata['grandtotal']=$whole;
						$udata['roundoff']=-(1-$fraction);
					}

					$upid=$this->bill_model->update($udata,array('id'=>$insert_id));
					######save in payment
					$paydata['amount']=$udata['grandtotal'];
					$paydata['billdate']=$data['billdate'];
					$paydata['billid']=$insert_id;
					$paydata['name']="bill ".$data['billno'];
					$paydata['useradd']=$user->id; 
					$paydata['voucher_id']=1;
					$Order=$this->orders_model->get_by_id($data['orderid']);
					$paydata['userid']=$Order[0]->user_id;
					$insert_id=$this->payment_model->insert($paydata);
					$this->session->set_flashdata('msg_ok',$this->lang->line('add_successfully'));
					redirect(base_url().'admin/bill/create?orderid='.$data['orderid']);
				}
			}
		}
		$data['obj']=$this->orders_model->get("*",array());
		$data['Quality']=$this->quality_model->get("*",array());
		$id=$this->input->get('orderid');
		$data['list']=$this->orders_model->get_by_id($id);
		$where1['orderid']=$id;
		$data['orderdetails']=$this->orders_model->get_Order_details("*",$where1);
		$data['orderid']=$id;
		$Total=$this->bill_model->get_last_bill_id();
		$data['billno']=$Total[0]->billno+1;
		$data['bill']=$this->bill_model->get("*",$where1);		
		$this->render_backend_tp('backends/bill/add',$data);
	}

	public function check_name_exist_add($name){
		$data=$this->orders_model->get_by_exact_name($name);
		if ($data!=null)
		{
			$this->form_validation->set_message('check_name_exist_add', 'This Order name has exist');
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}


	public function check_name_exist_edit(){
		$id=$this->input->post('id');
		$name=$this->input->post('name');
		$data=$this->orders_model->get_by_name_and_diff_id($id,$name);
		if($data!=null) {
			$this->form_validation->set_message('check_name_exist_edit', 'This Order name has exist');
			return FALSE;
		} else {
			return TRUE;
		}
	}	

	public function edit_get(){
		if(isset($_GET['billid'])){
			$orderid=$this->input->get('orderid');
			$billid=$this->input->get('billid');
			$data['obj']=$this->orders_model->get("*",array());
		$data['Quality']=$this->quality_model->get("*",array());
		$id=$this->input->get('orderid');
		$data['list']=$this->orders_model->get_by_id($id);
		$where1['orderid']=$id;
		$data['orderdetails']=$this->orders_model->get_Order_details("*",$where1);
		$data['orderid']=$id;
		$Total=$this->bill_model->total(array(),array());
				
		$data['bill']=$this->bill_model->get_by_id($billid);
		$where1['billid']=$billid;
		$data['billdetails']=$this->bill_model->get_bill_details("*",$where1);
		$this->template->write_view('content','backends/bill/edit',$data);
		$this->template->render();
		}
	}

	public function edit_post(){
		$user=$_SESSION['user'][0];
		if(isset($_POST['id'])){
			$id=$_POST['id'];
			$data = $_POST;	 
			
			$this->form_validation->set_rules('billdate','billdate', 'trim|required');//|callback_check_name_exist_add
				
			if($this->form_validation->run()!=false){
				$data = $_POST;	        	
	        	unset($data['orderdetailsid']);
	        	unset($data['quantity']);
	        	unset($data['rate']);
	        	unset($data['description']);
	        	unset($data['width']);
	        	unset($data['oid']);
	        	unset($data['totalpiece']);
	        	unset($data['countmore']);
	        	unset($data['countlimit']);
	        	unset($data['orderselect']);
	        	
	        	
				$data['billdate']=convert_time_format($_POST['billdate']);	
				$data['useradd']=$user->id; 
				
				$insert_id=$this->bill_model->update($data,array('id'=>$id));
				$insert_id=$id;
				if($insert_id!=0){
					
					$orderdetailsid=$_POST['orderdetailsid'];
					$quantity=$_POST['quantity'];
					$rate=$_POST['rate'];
					$description=$_POST['description'];
					$width=$_POST['width'];
					$totalpiece=$_POST['totalpiece'];
					$oid=$_POST['oid'];
					$cgst=0;$sgst=0;$subtotal=0;
					#####Before insert/update delete the (-) icon 
					$where1['billid']=$id;
					$billdetails=$this->bill_model->get_bill_details("*",$where1);
					foreach($billdetails as $okey=>$ovalue)
					{
						$bid=$ovalue->id;
						$deletedata['id']=$bid;
						if (!in_array($bid, $oid)) {
						  $bdetils=$this->bill_model->remove_billdetails($deletedata); 
						}
					}
					foreach($orderdetailsid as $detkey=>$detval)
					{
						$odata['orderdetailsid']=$detval;
						$odata['quantity']=$quantity[$detkey];
						$odata['rate']=$rate[$detkey];
						$odata['description']=$description[$detkey];
						$odata['totalpiece']=$totalpiece[$detkey];
						$odata['width']=$width[$detkey];
						//$odata['useradd']=$user->id; 
						$odata['billid']=$insert_id;
						$odata['orderid']=$data['orderid'];
						$billdetails=$oid[$detkey];
						$odata['totalamount']=$odata['quantity']*$odata['rate'];
						$odata['cgst']=$odata['sgst']=$odata['igst']=0;
						if($data['gst']=="0"){
						$odata['cgst']=number_format((float)(($odata['totalamount']*CONST_CGST)/100), 2, '.', '');
						$odata['sgst']=number_format((float)(($odata['totalamount']*CONST_SGST)/100), 2, '.', '');
							}
							if($data['gst']=="2"){
								$odata['cgst']=number_format((float)(($odata['totalamount']*CONST_CGST9)/100), 2, '.', '');
								$odata['sgst']=number_format((float)(($odata['totalamount']*CONST_SGST9)/100), 2, '.', '');
									}
						if($data['gst']=="1")
						$odata['igst']=number_format((float)(($odata['totalamount']*CONST_IGST)/100), 2, '.', '');

						


						if($odata['orderdetailsid']!=""&&$odata['quantity']!=""&&$odata['rate']!="")
						{
						  
						  if($billdetails != "")
						  	$bdetils=$this->bill_model->update_billdetails($odata,array("id"=>$billdetails));	
						  else
						  	 $bdetils=$this->bill_model->insert_billdetails($odata);

						$cgst += $odata['cgst'];
						$sgst += $odata['sgst'];
						$igst += $odata['igst'];
						$subtotal += $odata['totalamount'];
						}
					}
					$screencgst=$screensgst=$screenigst=0;
					$transcgst=$transsgst=$transigst=0;
					if($data['screencost'] != "")
					{
						if($data['gst']=="0"){
						$screencgst=number_format((float)(($data['screencost']*CONST_CGST)/100), 2, '.', '');
						$screensgst=number_format((float)(($data['screencost']*CONST_SGST)/100), 2, '.', '');
						}
						if($data['gst']=="2"){
							$screencgst=number_format((float)(($data['screencost']*CONST_CGST9)/100), 2, '.', '');
							$screensgst=number_format((float)(($data['screencost']*CONST_SGST9)/100), 2, '.', '');
							}
						if($data['gst']=="1")
						$screenigst=number_format((float)(($data['screencost']*CONST_IGST)/100), 2, '.', '');
					} else $data['screencost']=0;
					if($data['transportcharge'] != "")
					{
						if($data['gst']=="0"){
						$transcgst=number_format((float)(($data['transportcharge']*CONST_CGST)/100), 2, '.', '');
						$transsgst=number_format((float)(($data['transportcharge']*CONST_SGST)/100), 2, '.', '');
					}
					if($data['gst']=="2"){
						$transcgst=number_format((float)(($data['transportcharge']*CONST_CGST9)/100), 2, '.', '');
						$transsgst=number_format((float)(($data['transportcharge']*CONST_SGST9)/100), 2, '.', '');
					}
						if($data['gst']=="1")
						$transigst=number_format((float)(($data['transportcharge']*CONST_IGST)/100), 2, '.', '');
					} else $data['transportcharge']=0;

					
					$udata['cgst']=number_format($cgst+$screencgst+$transcgst, 2, '.', '');
					$udata['sgst']=number_format($sgst+$screensgst+$transsgst, 2, '.', '');
					$udata['igst']=number_format($igst+$screenigst+$transigst, 2, '.', '');
					$udata['subtotal']=number_format($subtotal, 2, '.', '');
					$grandtotal=$subtotal+$udata['cgst']+$udata['sgst']+$udata['igst']+$data['screencost']+$data['transportcharge'];
					$grandtotal=number_format($grandtotal, 2, '.', '');
					$whole = floor($grandtotal);      // 1
					$fraction = $grandtotal - $whole; // .25
					if($fraction == 00)
					{
						$udata['grandtotal']=$whole;
						$udata['roundoff']=0;
					}
					elseif($fraction >= .50)
					{
						$udata['grandtotal']=$whole+1;
						$udata['roundoff']=1-$fraction;
					}
					else
					{
						$udata['grandtotal']=$whole;
						$udata['roundoff']=-(1-$fraction);
					}

					$upid=$this->bill_model->update($udata,array('id'=>$insert_id));
					######Update in payment
					$paydata['amount']=$udata['grandtotal'];
					$paydata['billdate']=$data['billdate'];
					$insert_id=$this->payment_model->update($paydata,array('billid'=>$insert_id,'voucher_id'=>1));
					$this->session->set_flashdata('msg_ok',$this->lang->line('add_successfully'));
					redirect(base_url().'admin/bill');
				}
			}
			
		}
		$orderid=$_POST['orderid'];
		$billid=$_POST['id'];
		$data['obj']=$this->orders_model->get("*",array());
		$data['Quality']=$this->quality_model->get("*",array());
		$id=$orderid;
		$data['list']=$this->orders_model->get_by_id($id);
		$where1['orderid']=$id;
		$data['orderdetails']=$this->orders_model->get_Order_details("*",$where1);
		$data['orderid']=$id;
		$Total=$this->bill_model->total(array(),array());			
		$data['bill']=$this->bill_model->get_by_id($billid);
		$where1['billid']=$billid;
		$data['billdetails']=$this->bill_model->get_bill_details("*",$where1);
		$this->template->write_view('content','backends/bill/edit',$data);
		$this->template->render();


		
	}

	public function delete(){		
		if(isset($_GET['billid'])){
			$id=$this->input->get('billid');
			$user=$this->bill_model->get_by_id($id);
			$this->bill_model->remove_by_id($id);
			$this->bill_model->remove_billdetails(array('billid'=>$id));
			$this->payment_model->remove(array('billid'=>$id));
			$this->session->set_flashdata('msg_ok',$this->lang->line('delete_successfully'));
		}

		redirect('admin/bill');
	}

	public function activate(){
				if(isset($_GET['id'])){
			$id=$this->input->get('id');
			$this->orders_model->update(array('activated'=>1),array('id'=>$id));
			$this->session->set_flashdata('msg_ok','activated_successfully');
		}
		redirect('admin/orders');
	}

	public function lock(){		
		if(isset($_GET['id'])){
			$id=$this->input->get('id');
			$this->orders_model->update(array('activated'=>0),array('id'=>$id));
			$this->session->set_flashdata('msg_ok','deactivated_successfully');
		}
		redirect('admin/orders');
	}
public function loop(){	
	$bill=$this->bill_model->get("*",array());
	foreach($bill as $key=>$value)
	{
		######save in payment
					$paydata['amount']=$value->grandtotal;
					$paydata['billdate']=$value->bill_date;
					$paydata['billid']=$value->id;
					$paydata['name']="bill ".$value->billno;
					$user=$_SESSION['user'][0];	
					$paydata['useradd']=$user->id; 
					$paydata['voucher_id']=1;
					$Order=$this->orders_model->get_by_id($value->orderid);
					$paydata['userid']=$Order[0]->user_id;
					//print_r($paydata);
					$insert_id=$this->payment_model->update($paydata,array('billid'=>$value->id,'voucher_id'=>1));
					//$insert_id=$this->payment_model->insert($paydata);
	}
}	
}
?>