<?php
class Bank extends MY_Controller{
	function __construct()
	{
		parent::__construct();
		if(!isset($_SESSION['user'])){
			redirect('admin/dashboard');
		}else{
			$user=$_SESSION['user'][0];
			if($user->user_type !="ADM" ){
				redirect('admin/denied');
			}
		}
		$this->load->model('quality_model');
		$this->load->model('bank_model');
		$this->load->model('users_model');
		$this->load->model('orders_model');
		$this->form_validation->set_error_delimiters('<span class="help-inline msg-error" generated="true">', '</span>');
		$this->load->helper('Ultils');
	}

	function index(){
		
		$this->render_backend_tp('backends/bank/index');
	}

	public function ajax_list()
	{
		$list = $this->bank_model->get_datatables();
		$data = array();
		$no = $_POST['start'];
		foreach ($list as $customers) {
			$no++;
			$row = array();
			$row[] = $no;
			$row[] = $customers->name;
			$row[] = '<a href="'.base_url().$customers->file.'" target=_blank>File</a>';
			$row[] = $this->bank_model->get_action($customers->id);

			$data[] = $row;
		}

		$output = array(
						"draw" => $_POST['draw'],
						"recordsTotal" => $this->bank_model->count_all(),
						"recordsFiltered" => $this->bank_model->count_filtered(),
						"data" => $data,
				);
		//output to json format
		echo json_encode($output);
	}


	public function create(){
		$error=null;
		if(isset($_POST['name'])){		
			
			$this->form_validation->set_rules('name','name', 'trim|required|min_length[3]|callback_check_name_exist_add');
			
			if($this->form_validation->run()!=false){
				$data['name']=$this->input->post('name');
				$insert_id=$this->bank_model->insert($data);
				
				if(isset($_FILES['image']) && !empty($_FILES['image']['name'])){
						$config=array();
						$dir='uploads/poupload';
						$filename=$_FILES['image']['name'];
						$_FILES['image']['name']=rename_upload_file($filename);
						$config['allowed_types'] = '*';
						
						$config['upload_path']=$dir;
						$this->load->library('upload',$config);
						if ($this->upload->do_upload('image'))
						{
							$data['file']=$dir.'/'.$_FILES['image']['name'];
							$this->bank_model->update($data,array('id'=>$insert_id));
							$this->session->set_flashdata('msg_ok', $this->lang->line('add_successfully'));
							redirect(base_url().'admin/bank/index');
						}else{
							$this->session->set_flashdata('msg_error', $this->upload->display_errors());
							redirect(base_url().'admin/bank/create');
						}
					}
				
				if($insert_id){
					$this->session->set_flashdata('msg_ok',$this->lang->line('add_successfully'));
					redirect(base_url().'admin/bank/index');					
				}
			}
		}
		$this->render_backend_tp('backends/bank/add');
	}	

	public function check_name_exist_add($phone){
		$data=$this->bank_model->get_by_name($phone);
		if ($data!=null)
		{
			$this->form_validation->set_message('check_name_exist_add', 'This Name already exists');
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	public function check_name_exist_edit(){
		$id=$this->input->post('id');
		$name=$this->input->post('name');
		$data=$this->bank_model->get_by_name_and_diff_id($id ,$name);
		if($data!=null) {
			$this->form_validation->set_message('check_name_exist_edit', 'This Name already exists');
			return FALSE;
		} else {
			return TRUE;
		}
	}

	public function edit_get(){
		if(isset($_GET['id'])){
			$id=$this->input->get('id');
			$data['obj']=$this->bank_model->get_by_id($id);
			$this->template->write_view('content','backends/bank/edit',array('data'=>$data));
			$this->template->render();
		}
	}

	public function edit_post(){
		if(isset($_POST['id'])){
			$id=$_POST['id'];
					
			$this->form_validation->set_rules('name','name', 'trim|required|min_length[3]|callback_check_name_exist_edit');
			
			if($this->form_validation->run()){
				$update_data['name']=$this->input->post('name');
				
				$this->bank_model->update($update_data,array('id'=>$id));
				if(isset($_FILES['image']) && !empty($_FILES['image']['name'])){
						$config=array();
						$dir='uploads/poupload';
						$filename=$_FILES['image']['name'];
						$_FILES['image']['name']=rename_upload_file($filename);
						$config['allowed_types'] = '*';
						
						$config['upload_path']=$dir;
						$this->load->library('upload',$config);
						if ($this->upload->do_upload('image'))
						{
							$data['file']=$dir.'/'.$_FILES['image']['name'];
							$this->bank_model->update($data,array('id'=>$id));
							$this->session->set_flashdata('msg_ok', $this->lang->line('add_successfully'));
							redirect(base_url().'admin/bank/index');
						}else{
							$this->session->set_flashdata('msg_error', $this->upload->display_errors());
							redirect(base_url().'admin/bank/edit_get?id='.$id);
						}
					}
				$this->session->set_flashdata('msg_ok',$this->lang->line('edit_successfully'));
				redirect(base_url().'admin/bank/index');
				
			}
			$data['obj']=$this->bank_model->get_by_id($id);
			$this->template->write_view('content','backends/bank/edit',array('data'=>$data));
			$this->template->render();


		}
	}

	public function delete(){
		$page=$_GET['page'];
		if(isset($_GET['id'])){
			$id=$this->input->get('id');
			$this->bank_model->remove_by_id($id);			
		}
		$this->session->set_flashdata('msg_ok',$this->lang->line('delete_successfully'));
		redirect('admin/bank'.$page);
	}

	public function activate(){
		$page=$_GET['page'];
		if(isset($_GET['id'])){
			$id=$this->input->get('id');
			$this->bank_model->update(array('activated'=>1),array('id'=>$id));
		}
		redirect('admin/bank/'.$page);
	}

	public function lock(){
		$page=$_GET['page'];
		if(isset($_GET['id'])){
			$id=$this->input->get('id');
			$this->bank_model->update(array('activated'=>0),array('id'=>$id));
		}
		redirect('admin/bank/'.$page);
	}

	
}
?>